function [r, valididx, clip_ids] = ranking_from_comparison_trivial(comparison, comparison_ids)
% returns a ranking for each of the compared songs 
%
% r(idx,1) =  all indexes which are similar to clip idx
% r(idx,2) = all indexes which are dissimilar to clip idx
%
% if onlyvalid is set to true, only the transitive hull of 
% clips having sim and dissim values will be output

% ---
% in comparison, the outlying piece is highlighted. 
% thus, we naively consider that
% a. both of the remaining pieces are more similar to each other.
% b. the outlier is dissimilar to both of the other pieces
% ---

[outsort, outidx] = sort(comparison(:,4:6),2,'ascend');

r = cell(numel(comparison_ids), 2);
s = zeros(numel(comparison_ids), 2); % score for rankings
for i = 1:size(comparison, 1)

    % get the three relevant comparison ids

    pos = comparison(i, outidx(i,1:3));
    vals = outsort(i,:);
    
    % ---
    % each of the three clips will be evaluated based on its position
    % the last clip is the potential outlyier
    % ---
    
    % ---
    % usual case: two small values and a last outlie
    % ---
    if vals(2) ~= vals(3)
        
        
        % ---
        % first (most common) clip:
        % the second clip is more similar than the third one
        % ---
        r{pos(1),1} = cat(1, r{pos(1),1}, pos(2));  % similar
        r{pos(1),2} = cat(1, r{pos(1),2}, pos(3));  % dissimilar
%     else
%         
%         % ok, both seem more dissimilar to clip 1
%         r{pos(1),2} = cat(1, r{pos(1),1}, pos(2));  % both dissimilar
%         r{pos(1),2} = cat (1, r{pos(1),2}, pos(3));  % dissimilar
    end
    
    if vals(3) ~= vals(1)
        % ---
        % the second clip is more similar to the first than 
        % the third
        % ---
        r{pos(2),1} = cat(1, r{pos(2),1}, pos(1));
        r{pos(2),2} = cat(1, r{pos(2),2}, pos(3));
    
        % ---
        % the third clip is not similar to any of the former 
        % NOTE: we avoid this information as it possibly leads 
        % to some contradictionary statements
        % ---
            r{pos(3),2} = cat(1, r{pos(3),2}, pos(1));
            r{pos(3),2} = cat(1, r{pos(3),2}, pos(2));
    end
    

end

% ---
% we cleanup r and 
% run basic checks on emptiness and paradox assumptions
% ---
valididx = zeros(size(r,1), 1);
for i = 1:size(r, 1)
    
    % make unique
    r{i,1} = unique(r{i,1});
    r{i,2} = unique(r{i,2});
    
    % check
    valididx(i) = ~isempty(r{i,1}) && ~isempty(r{i,2}) && ...
        isempty(intersect(r{i,1}, r{i,2}));
end

valididx = logical(valididx);
clip_ids = 1:numel(comparison_ids);

