function [tags,count, out] = mb_retrieve_tags_for_artist_id(artistid)

% song info API
url = sprintf('http://www.musicbrainz.org/ws/2/artist/%s?inc=tags',urlencode(artistid));
[status] = wget(url,'--tries=10 -U firefox -O tmp.xml');

try
    out = xml2struct('tmp.xml');
    tags = cell(numel(out.metadata.artist.tag_dash_list.tag),1);
    count = zeros(numel(out.metadata.artist.tag_dash_list.tag),1);
    for i=1:numel(out.metadata.artist.tag_dash_list.tag)
       tags{i} = out.metadata.artist.tag_dash_list.tag{i}.name.Text;
       count(i) = str2double(out.metadata.artist.tag_dash_list.tag{i}.Attributes.count);
    end
catch
    out = [];
    tags = {};
    count = [];
end