classdef MTTMixedFeatureGenreRandom < MTTAudioFeature & handle
    % ---
    %
    % The usual worklow for these features constist of three steps
    % 1. extract: extracts the basic single-file dependent features
    % 2. define_global_transform: calculates the global feature
    %       transformation parameters
    % 3. finalise: applies the common transformations to a specific feature
    % ---
    
    properties(Constant = true)
        
        % svn hook
        my_revision = str2double(substr('$Rev: 455 $',  5, -1));
    end
       
    properties
        % ---
        % Set default parameters
        % ---
        my_params = MTTAudioFeature.inherited_params(...
            'MTTTagFeatureGenreBasic', ...
            ... % ---
            ... % following are Random parameters
            ... % --- 
            'nrandoms', 100 ...
        );
    end
    
    % ---
    % member functions
    % ---
    methods
        
        % ---
        % constructor: pointer to feature in database
        % ---
        function feature = MTTMixedFeatureGenreRandom(varargin)

            feature = feature@MTTAudioFeature(varargin{:});
        end

        % ---
        % extract feature data by combining genre adn basicsm features
        % ---
        function data = extract(feature, clip)
            
            % ---
            % get MTTMixedFeatureGenreBasicSm this includes possible
            % local normalisations
            % ---
            data.tags = clip.features('MTTTagFeatureGenreBasic',feature.my_params);
            
            % ---
            % get genre tag features
            % ---
            
            data.random = clip.features('MTTRandomFeature',feature.my_params);
            
            
            % prepare field for final features
            data.final.vector = [];
            data.final.vector_info = struct(); 
            data.final.dim = 0;
           
            % save info data
            data.info.type = class(feature);
            data.info.owner_id = clip.id;
            data.info.creatorrev = feature.my_revision;
            
            % save parameters
            data.info.params = feature.my_params;
        end
        
        function define_global_transform(features)
        % calculate and set normalization factors from the group of 
        % input features. These features will be set for the full database
        
            if numel(features) == 1
                error ('Insert feature array for this method');
            end
            
            % ---
            % We collect all the relevant tag 
            % features and get the transform on this basis.
            % ---
            for i = 1:numel(features)
            	tags(i) = features(i).data.tags;
            end
            
            % call the features own transsform function
            tags.define_global_transform();
            
            % ---
            % Random features have no global transform
            % ---

            % ---
            % set common feature values for mixed features
            % ---
            features(1).my_db.set_common([1]); %trivial common
        end
        
        
        function finalise(feature)
        % applies a final transformation and collects the 
        % information of this feature within a single vector
        % see info for types in specific dimensions

            for i = 1:numel(feature)
                
                % check for neccesary parameters
                if isempty(feature(i).my_db.commondb)

                    error('Define the global transformation first');
                end
                
                % ---
                % final data assembly
                % ---
                % concatenate vectors
                feature(i).data.final.vector = ...
                    [feature(i).data.tags.vector() ;...
                    feature(i).data.random.vector()];
                
                % add up feature dimensions
                feature(i).data.final.dim = feature(i).data.tags.dim...
                    + feature(i).data.random.dim;
                
                % concatenate labels
                lbl1 = feature(i).data.tags.labels();
                lbl2 = feature(i).data.random.labels();
                feature(i).data.final.vector_info.labels = ...
                    {lbl1{:}, lbl2{:}};
            end
        end
        
        % ---
        % destructor: do we really want to remove this 
        % from the database? No, but 
        % TODO: create marker for unused objects in db, and a cleanup
        %  function
        % ---
        function delete(feature)
            
        end
    end
end