function out = strcellfind(strdb, str, findAll)
% out = strcellfind(strdb, str)
% 
% finds a string within an cell array of strings
% only outputs the first occurence, unless
% findAll is set to true
%
% strcellfind is NOT CASE sensitive

if nargin < 3
    findAll = 0;
end

out = [];
for i = 1:length(strdb)
    if strcmpi( lower(char(strdb{i})), lower(char(str))) == 1;
        if ~findAll
            out = i;
            return;
        else
            out(end+1) = i;
        end
    end
end
% ---
% NOTE: Bad backwards compability
% ---
% if isempty(out)
%     out = -1;
% end