function [out] = strcell2matrix(in, start, finish)
%
% out = strcell2matrix(in,start)
%
% in: cell array containing string numbers (from csv2cell) 
% start: start offset of first number [row, column]
% finish: end offset

% e.g. annots = strcell2matrix(annotations_final,[1 0], [0 0])

if nargin == 1
    start = [0 0];
    finish = [0 0];
end

if nargin == 2
     finish = [0 0];
end


% ---
% Get the data and ignore the rest
% ---
out = zeros(size(in) - start - finish);


for i = (1 + start(1)):size(in,1) - finish(1)
    for j = (1 + start(1)):size(in,2) - finish(2)
        
        out(i - start(1), j - start(2)) = str2double(in{i,j});
    end
end
