function w = svmlight2weight(modelfile)
% returns the dual weight vecor for a given svm model
%
% All the script does is compute the weighted sum of the support vectors
% (first element in line is alpha*y, what follows is the feature vector).
% For further info, see the comment in the model file for its format. 

tagstr = python('svmlight2weight.py', modelfile);

[firstidx] = strfind(tagstr, '1 :');

%get start of vector description
tagstr = tagstr(firstidx:end);

% parse text function output
vecs = textscan(tagstr,'%d %f','Delimiter',':');

% initialise
w = zeros(max(vecs{1}),1);

% set values
w(vecs{1}) = vecs{2};

