function success = save_svmlight_inequalities(lhs, rhs, factors, file)
% success = save_svmlight_inequalities(lhs, rhs, file)
%
% saves the optimisation problem given by lhs and rhs to
% a svmlight data file. the individual equations can 
% be weighted using 
%
% success = save_svmlight_inequalities(lhs, rhs, factors, file)

if nargin == 3
    file = factors;
    factors = [];
end

% open file
fid = fopen(file, 'w+');
if fid < 1 
    success = 0;
    return;
end

try 
    % write individual constraint rows
    for i = 1:size(lhs,1)

        % ---
        % print rows:" rhs #fnum:#fval #fnum:#fval #fnum:#fval ..."
        % ---

        % print right hand side
        fprintf(fid,'%d ', rhs(i));

        % print cost factors if availablefactor
        if (numel(lhs{i,1}) > 0) && (numel(factors) >= i)

            fprintf(fid,'cost:%f ', factors(i));
        end

        % print left hand side
        for j = 1:numel(lhs{i,1})

            fprintf(fid,'%d:%2.16f ', lhs{i,1}(j), lhs{i,2}(j));
        end

        % finish line
        fprintf(fid,'\n');
    end  
catch
    success = 0;
    fclose(fid);
    return;
end
success = 1;
fclose(fid);

    
    