function [X, C, idx] = get_itml_deltas(r, in)
% [X, C, idx] = get_itml_deltas(r, in)

%ITML Specs
% C: 4 column matrix
%      column 1, 2: index of constrained points.  Indexes between 1 and n
%      column 3: 1 if points are similar, -1 if dissimilar
%      column 4: right-hand side (lower or upper bound, depending on 
%                   whether points are similar or dissimilar)
%
% X: (n x m) data matrix - each row corresponds to a single instance
% ---
% NOTE: X is thus input in transposed shape for the ITML algorithm
% ---

% ---
% NOTE: this preallocation is not complete
% ---
X = zeros(size(in,1), 0);
C = zeros(0,4);
idx = zeros(0,2);

for i = 1:size(r,1)
    
    % feature indexing
    a = i;
    
    % check if ranking is valid
    if ~isempty(r{i,1}) && ~isempty(r{i,2})&& ...
        isempty(intersect(r{i,1}, r{i,2}));
    
        % ---
        % NOTE / TODO: the follwing is intended for compability
        %  both sides of the ranking may have more than one entry.
        %  for the MTT database, the ranking may be correct, but the 
        %  inequalities build from non-singular rankings are not
        %  based on the actual data
        % ---
        for j = 1:numel(r{i,1})
            b = r{i,1}(j);
            
            for k = 1:numel(r{i,2})
                c = r{i,2}(k);

                % ---
                % get vector deltas
                % ---
                [dab] = in(:,a) - in(:,b);
                [dac] = in(:,a) - in(:,c);
                
                % ---
                % save deltas in new feature matrix
                % TODO: this method has duplicate entries
                %  if the pairs appear more than once
                %  index the data set and use more efficiently!!!
                % ---
                X = [X dab];
                idx(end+1,:) = [a b];
                iab = size(idx, 1);
                
                X = [X dac];
                idx(end+1,:) = [a c];
                iac = size(idx, 1);
                
                % ---
                % NOTE:
                % in terms of the constraint,
                %  this should mean: dac - dab >= 1
                %
                % 4th position cannot be 0, converges to Inf if > 1
                % -1,-1 learns the opposite of what constraitns say
                % ---
                C(end+1, :) = [iab iac -1 -1];
            end
        end
    end
end

% % ---
% % NOTE: here, we transpose the X for usage i nthe training
% % ---
% X = X';

end

