function [Yout, Xout] = mlr_repeat_YX_by_rating(Y, X, weights)
% [Yout, Xout] = mlr_repeat_YX_by_rating(Y, X, weights)
% 
% repeats the data in X and Y according to the weights specified
% in weights or Y(:,3)

cprint(2, 'Repeating data for weighted learning');
if nargin == 2
    weights = cell2mat(Y(:,3));
end

Yout = Y(:,1:2);

valid = ~(cellfun(@isempty, Y(:,1)) | cellfun(@isempty, Y(:,2)));

for i = 1:size(Y, 1)
    if valid(i)
        for j = 2:weights(i)
            Yout(end + 1, :) = Y(i, 1:2);
        end
    end
end

Xout = zeros(size(X,1), size(Y,1));
Xout(:,1:size(X,2)) = X;
for i = 1:size(Y, 1)
    if valid(i)
        for j = 2:weights(i)
            Xout(:,end+1) = X(:,i);
        end
    end
end