%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Experiment code templat                                                 %
% Project: sub-euclidean distance for music similarity                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Load features
feature_file = 'rel_music_raw_features.mat';
vars = whos('-file', feature_file);
A = load(feature_file,vars(1).name,vars(2).name,vars(3).name,vars(4).name);
raw_features = A.(vars(1).name);
indices      = A.(vars(2).name);
tst_inx      = A.(vars(3).name);
trn_inx      = A.(vars(4).name);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Define directory to save parameters & results
% dir    = '/home/funzi/Documents/';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
dmr    = [0 5 10 20 30 50];    % dimension reduction by PCA
ws     = [0 5 10 20 30 50 70]; % window size
% parameters of rbm (if it is used for extraction)
hidNum = [30 50 100 500];
lr_1   = [0.01 0.05 0.1 0.5];
lr_2   = [0.05 0.1 0.5 0.7];
mmt    = [0.02 0.05 0.1 0.5];
cost   = [0.00002 0.01 0.1];

%% Select parameters (if grid-search is not applied)
di  = 1;
wi  = 1;
hi  = 4;
l1i = 1;
l2i = 1;
mi  = 4;
ci  = 1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% If grid search is define
% log_file = strcat(dir,'exp_.mat');
% inx = resume_from_grid(log_file,8);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Feature extraction
EXT_TYPE = 2;
switch (EXT_TYPE)
    case 1  % Using PCA
        assert(~exist('OCTAVE_VERSION'),'This script cannot run in octave');
        coeff = princomp(raw_features);
        coeff = coeff(:,1:end-dmr(di));  % Change value of dmr(di) to reduce the dimensionality
        features = raw_features*coeff;
          % normalizing
        mm = minmax(features')';
        inn= (find(mm(1,:)~=mm(2,:)));
        mm = mm(:,inn);
        features = features(:,inn);
        features = (features-repmat(mm(1,:),size(features,1),1))./(repmat(mm(2,:),size(features,1),1)-repmat(mm(1,:),size(features,1),1));
        
        % describe config
        s_conf = xml_format(dmr(di));
    case 2  % Using rbm
        conf.hidNum = hidNum(hi);
        conf.eNum   = 100;
        conf.sNum   = size(raw_features,1);
        conf.bNum   = 1;
        conf.gNum   = 1;
        conf.params = [lr_1(l1i) lr_2(l2i) mmt(mi) cost(ci)];
        conf.N    = 50;
        conf.MAX_INC = 10;
        W1 = zeros(0,0);
        [W1 vB1 hB1] = training_rbm_(conf,W1,raw_features);
        features = logistic(raw_features*W1 + repmat(hB1,conf.sNum,1));
        
        % describe config
        s_conf = xml_format(conf);
end

correct = 0;   % correct rate
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% CODE HERE                               %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nfvec = features';
feature_file = 'son_out_files.mat';
save(feature_file,'nfvec');


% the calling of daniels script
ftype = 'MTTMixedFeatureSon';
global sonfeatbase;
sonfeatbase = [];

global db_MTTMixedFeatureSon
db_MTTMixedFeatureSon.reset

global globalvars;
globalvars.debug = 2

fparams_all.son_conf = {s_conf};
fparams_all.son_filename = {feature_file};

% ---
% vary parameters for svmlight
% ---    

trainparams_all = struct(...
            'C', [0.05 0.1 3 10 100], ...   %you just want to try this parameter approx (0.01..........1000) (3-100 is nice for daniel)
            ...               
            'weighted', [0], ...
            'dataset',{{'comp_partBinData_cupaper_01'}}, ...
            'inctrain', 0, ...
            'deltafun', {{'conv_subspace_delta'}}, ...
            'deltafun_params', {{{[0],[1]},{[5],[1]},{[20],[1]},{[40],[1]}}} ... % normalisation improves results
            );

% set training function
trainfun = @svmlight_wrapper;


% create test dirxectory
akt_dir = migrate_to_test_dir();

% call eval
result = test_generic_features_parameters_crossval...
    (fparams_all, trainparams_all, trainfun, ftype);

% correct = result.mean_ok_test(1,1);
% fprintf('Correct = %f\n',correct);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Using the logging function to save paramters
% and the result for plotting or in grid search
% logging(log_file,[i1 i2 i3 i4 i5 correct]);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



