function  [clip_dict, X, Y, valididx] = get_data_compact(clips, featureVec, simdata)
    % ---
    % instead of creating a new three feature vectors 
    % for each constraint, this function links back to the 
    % FIRST occurrence of a distinct clip and its features
    % 
    % TODO: try to always link ALL occurences of a feature
    % / clip in the rankings
    % ---

    global comparison_ids;
    global comparison_invids;
    
    % ---
    % build the clip dictionary 
    % ---
    uniclip = unique(reshape( simdata, 1, []));
    last_clip_pos = zeros(1, numel(uniclip));
    
    clip_dict = [];
    Y = {};
    idx_newclip = 1;
    valididx = logical([]);

    % cycle all constraints of one cv bin
    for j = 1:size(simdata,1)

        
        % save the first clip
        constraint = simdata(j,:);
        
        % ---
        % check where the clip is and if there
        % is space to write cosntraint data
        % 
        % If not, a position is created
        a = find_clip(constraint(1), 1);
        b = find_clip(constraint(2), 0);
        c = find_clip(constraint(3), 0);

        % [a,b,c] -> clip a more similar to clip b than to clip c 
        
        % adress weightings
        if numel(constraint) == 4
            Y(a,:) = {b, c, (constraint(4))};
        else
            Y(a,:) = {b, c};
        end
    end
    
    % ---
    % get feature data
    % NOTE: this uses an index of the comparison clips
    % ---
    X = featureVec(:,(comparison_invids(clip_dict)));
    
    for i = find(~valididx)
        if size(Y,2) == 3
           Y(i,:) = {[], [], 0};
        else
           Y(i,:) = {[], []}; 
        end
    end
    
    function clip_idx = find_clip(clip, write)
        uc_idx = find(uniclip == clip);
        
        % ---
        % do we have a place of this clip? 
        % 
        % NOTE: last_clip_pos has to be reset after every write
        % ---
        if (last_clip_pos(uc_idx) == 0) || ...
                write && (numel(valididx) >= last_clip_pos(uc_idx)) &&...
                (valididx(last_clip_pos(uc_idx)) == 1)
            
            % if not, create one
            clip_idx = idx_newclip;
            clip_dict(clip_idx) = clip;
            valididx(clip_idx) = false;
            
            % and save into last pos
            last_clip_pos(uc_idx) = clip_idx;

            idx_newclip = idx_newclip + 1;
        else
            clip_idx = last_clip_pos(uc_idx);
        end
        
        if write
            valididx(clip_idx) = true;
        end
        
    end
    
end
