function  sim_from_comparison_attach_weights(filen)

global comparison;
global comparison_ids;
% load data from mat file
load(filen);

% ---
% get the similarity multigraph and remove cycles
% ---
cprint(2, 'creating graph')
Gm = ClipSimGraphMulti(comparison, comparison_ids);
Gm.remove_cycles_length2; 

nTestSets = size(partBinTst, 2); % num cv bins
ntrainsizes = size(partBinTrn, 2); % num increases of training

% ---
% test sets
% ---
cprint(2, 'doing test sets')

% for all validations 
for k = 1:size(partBinTst, 2);
    
    % for each constraint tiplet
    for i = 1:size(partBinTst{k},1)
        
        % get weight for this edge from graph
        [weight, ~, ~] = Gm.edge(partBinTst{k}(i,1), partBinTst{k}(i,2),...
            partBinTst{k}(i,3));
            
            if isempty(weight) || weight == 0
                error 'inconsistent similarity data';
            end
        
        % save into same data structure
        partBinTst{k}(i,4) = weight;
    end
end

% ---
% train sets
% ---

cprint(2, 'doing train sets')
% for all validations 
for k = 1:size(partBinTrn, 1);
    
    % for all training sizes
    for m = 1:size(partBinTrn, 2);
        
        % for each constraint tiplet
        for i = 1:size(partBinTrn{k,m},1)

            % get weight for this edge from graph
            [weight, ~, ~] = Gm.edge(partBinTrn{k,m}(i,1), partBinTrn{k,m}(i,2),...
                partBinTrn{k,m}(i,3));
            
            if isempty(weight) || weight == 0
                error 'inconsistent similarity data';
            end
            
            % save into same data structure
            partBinTrn{k,m}(i,4) = weight;
        end
    end
end

% ---
% Notrain sets
% ---
cprint(2, 'doing Notrain sets')
% for all validations 
for k = 1:size(partBinNoTrn, 1);
    
    % for all training sizes
    for m = 1:size(partBinNoTrn, 2);
        
        % for each constraint tiplet
        for i = 1:size(partBinNoTrn{k,m},1)

            % get weight for this edge from graph
            [weight, ~, ~] = Gm.edge(partBinNoTrn{k,m}(i,1), partBinNoTrn{k,m}(i,2),...
                partBinNoTrn{k,m}(i,3));
            
            if isempty(weight) || weight == 0
                error 'inconsistent similarity data';
            end
            % save into same data structure
            partBinNoTrn{k,m}(i,4) = weight;
        end
    end
end

% save results to mat file
save(sprintf('%s_weighted.mat',filen), 'partBinTst', 'partBinTrn', 'partBinNoTrn');
