function mlr_unittest(X, Yrel)

% Loss values to test
    LOSS    = {'AUC', 'Prec@k', 'MAP', 'MRR', 'NDCG'};


    % Regularization values to test
    REG = [0,1,2,3];

    % Batch sizes to test
    BATCH = [0 1 5];

    % Diagonal settings
    DIAG = [0 1];

    figure(1);
    for l = 1:length(LOSS)
        display(['Testing ', LOSS{l}]);
        for r = 1:length(REG)
            display(sprintf('\tREG=%d', REG(r)));
            for b = 1:length(BATCH)
                display(sprintf('\tB=%d', BATCH(b)));
                for d = 1:length(DIAG)
                    display(sprintf('\tDiagonal=%d', DIAG(d)));
                    [W, Xi, D] = mlr_train(X, Yrel, 10e5, LOSS{l}, REG(r), DIAG(d), BATCH(b));
                    imagesc(W); drawnow;
%                     [W, Xi, D] = mlr_train(X, Yclass, 10e5, LOSS{l}, REG(r), DIAG(d), BATCH(b));
%                     imagesc(W); drawnow;
                end
            end
        end
    end

end
