function [artist_mbid, out] = mb_retrieve_artist_id_from_isrc(isrc)

% song info API
url = sprintf('http://www.musicbrainz.org/ws/2/isrc/%s',urlencode(isrc));
[status] = wget(url,'-t 10 -U firefox -O tmp.xml');

try
    out = xml2struct('tmp.xml');
    % album name for verification
    albumname = out.metadata.isrc.recording_dash_list.recording.title
    artist_mbid = out.metadata.isrc.recording_dash_list.recording.Attributes.id;
catch
    artist_mbid = [];
    out = [];
end