% makro_get_significance_cupaper
%%
% ------------------------------ Algorithms Compared id-sampling
% ---
'mlr vs euclidean, mlr all average feat, ID-sampling'
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_1a58077f1232c33b787b661039df107d_finalresults';

% euclidean average feat - TODO: which sampling is this ?
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1a9788c5e14f30e23ed2a05dbf513c9f_finalresults';
% ---
% NOTE: all 4 test-set runs have exactly the same result 
% ---
run1 = -1;
run2 = -1;
mode = 'join_datasets'; % '', 'avgbase', 'join_datasets'
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run1,0,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);


%%
% ---
'SVM vs euclidean, SVM all average feat, ID-sampling'
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_1841892e9df07039bbe4c3a55d11026a_finalresults';

% euclidean average feat - TODO: which sampling is this ?
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1a9788c5e14f30e23ed2a05dbf513c9f_finalresults';

[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,0,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

%%
% ------------------------------ Algorithms Compared TD-sampling
% ---
'mlr unclustered vs euclidean unclustered, mlr all average feat TD-sampling'
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_c364cb0803822d55f2940656c44b184d_finalresults';

% euclidean average feat TD-sampling
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_72303bfa642aad872665dee7a3b1e28c_finalresults';

[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,0,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

%%
% ---
'SVM unclustered vs euclidean unclustered, SVM all average feat TD-sampling'
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_3434f0534fa910b26bbf927c65a7fb74_finalresults';

% euclidean average feat TD-sampling
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_72303bfa642aad872665dee7a3b1e28c_finalresults';
% ---

[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,0,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);


%%
% ------------------------------ Features Compared 
'All 12-dim PCA Features compared'
% ---
namePCA12 = {'AcousticPCA12', ...
    'Slaney08PCA12', ...
    'TimbrePCA12', ...
    'ChromaPCA12', ...
    'AllPCA12', ...
    'GenrePCA12'};
% this is the index how the feature types appear in the paper
paperidx = [4 3 2 6 1 5];

filePCA12 = {'runlog_a18bd2111694ac59c9ba0a6810121796_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_37e47c187886f73ec9a7d8dc24a84a52_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_4c6787b403a07f5faf1ec26e891da4fa_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_c5566f74e6a0d00b50f5eea05fdacfee_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_e2c22696e7af9e7eea1fa1fd10a1f785_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_efc6e5e9c56291cd1744092a1c59a293_1841892e9df07039bbe4c3a55d11026a_finalresults'};


namePCA12 = namePCA12(paperidx);
filePCA12 = filePCA12(paperidx);

p = zeros(numel(namePCA12),numel(namePCA12));
med = zeros(numel(namePCA12),numel(namePCA12));
avg = zeros(numel(namePCA12),numel(namePCA12));
for i=1:numel(name)
    for j = 1:i-1
        [p(i,j), med(i,j), avg(i,j)] = test_generic_significance_signrank(filePCA12{i},-1,filePCA12{j},-1,0,mode);
    end
   % p(i,i) = 0.5;
end
% p = p + p';
imagesc(p);
colormap(hot)
axis xy
set(gca,'XTick',1:numel(namePCA12), 'XTickLabel', namePCA12);
set(gca,'YTick',1:numel(namePCA12), 'YTickLabel', namePCA12);
matrix2latex(p,'%1.3f')

%%
'All 52-dim PCA Features compared'
% ---
namePCA52 = {'GenrePCA52', ...
    'AllPCA52', ...
    'TimbrePCA52', ...
    'AcousticPCA52', ...
    'ChromaPCA52' ...
     };
% this is the index how the feature types appear in the paper
paperidx = [5 3 1 4 2];

filePCA52 = {'runlog_3cbf4759cf58af0728aaab0b5f2660e3_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_7d5fafec0dc504215acc8cb7a9202a56_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_a3c2c0a5742a42fd54497e69b8f44e8d_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_c7164074206998aa184538bedcfdcf2f_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_efbf7c8e75ae154c2f192acd08fbdcbc_1841892e9df07039bbe4c3a55d11026a_finalresults' ...
    };


namePCA52 = namePCA52(paperidx);
filePCA52 = filePCA52(paperidx);

p = zeros(numel(namePCA52),numel(namePCA52));
med = zeros(numel(namePCA52),numel(namePCA52));
avg = zeros(numel(namePCA52),numel(namePCA52));
for i=1:numel(name)
    for j = 1:i-1
        [p(i,j), med(i,j), avg(i,j)] = test_generic_significance_signrank(...
            filePCA52{i},run1,filePCA52{j},run2,0,mode);
    end
   % p(i,i) = 0.5;
end
% p = p + p';
imagesc(p);
colormap(hot)
axis xy
set(gca,'XTick',1:numel(namePCA52), 'XTickLabel', namePCA52);
set(gca,'YTick',1:numel(namePCA52), 'YTickLabel', namePCA52);
matrix2latex(p,'%1.3f')

%%
'All full-dim Features compared (SVM)'
% ---
name = {'4Chroma', ...
    '1Chroma', ...
    '4Timbre', ...
    '1Timbre', ...
    '1Acoustic', ...
    'Genre', ...
    'Slaney08', ...
    '1All', ...
    '4All', ...
    '4Acoustic' ...
    };

% this is the index how the feature types appear in the paper
% Features & Chroma(1/4) & Timbre(1/4) & Slaney08 & Genre & Comb. Audio (1/4) & Comb. All(1/4) \\
paperidx = [2 1 4 3 7 6 5 10 8 9];

file = {'runlog_20a2f6a0f20f488e9386ebb8c5026fcf_85c439d9ef3d135936e7645ebc0efe36_finalresults', ...
    'runlog_20a2f6a0f20f488e9386ebb8c5026fcf_85c439d9ef3d135936e7645ebc0efe36_finalresults', ...
    'runlog_3154f36c34c18f60218c5d3f0c0b5931_85c439d9ef3d135936e7645ebc0efe36_finalresults', ...
    'runlog_3154f36c34c18f60218c5d3f0c0b5931_85c439d9ef3d135936e7645ebc0efe36_finalresults', ...
    'runlog_31981d48dd0d25564ef3c2b3ca650b3b_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_37867d3b5bd4c74b7b548732b80fb947_85c439d9ef3d135936e7645ebc0efe36_finalresults', ...
    'runlog_f52d37439805ac4edc70b0432281abc3_85c439d9ef3d135936e7645ebc0efe36_finalresults', ...
    'runlog_0b506247a68167addf97fcb0296650eb_1841892e9df07039bbe4c3a55d11026a_finalresults', ...
    'runlog_800d97be9ef6274dc3bbe6b9be2406a6_1a58077f1232c33b787b661039df107d_finalresults', ...
    'runlog_cf5a61cca09e2a3182b794b70ee1ab91_1841892e9df07039bbe4c3a55d11026a_finalresults' ...
    };

sets2join = {[1:4],[5:8],[1:4],[5:8],[],[],[],[],[],[]};

name = name(paperidx);
file = file(paperidx);

p = zeros(numel(name),numel(name));
med = zeros(numel(name),numel(name));
avg = zeros(numel(name),numel(name));
for i=1:numel(name)
    for j = 1:i-1
        [p(i,j), med(i,j), avg(i,j)] = test_generic_significance_signrank(...
            file{i},sets2join{i},file{j},sets2join{j},0,mode);
    end
   % p(i,i) = 0.5;
end
p = flipud(p);
% p = p + p';
imagesc(p);
colormap(hot)
axis ij
set(gca,'XTick',1:numel(name), 'XTickLabel', name);
set(gca,'YTick',1:numel(name), 'YTickLabel', fliplr(name));
matrix2latex(p,'%1.3f')

%%
'Comparing Feature dimensions and PCA effect on combined all features'
% ---
% 'SVM all average feat, ID-sampling'
allavg = 'runlog_0b506247a68167addf97fcb0296650eb_1841892e9df07039bbe4c3a55d11026a_finalresults';

% 'SVM 4 cluster feat, ID-sampling'
allfourcluster = 'runlog_800d97be9ef6274dc3bbe6b9be2406a6_1a58077f1232c33b787b661039df107d_finalresults';

% 'SVM 12dim feat, ID-sampling'
pca12 = 'runlog_e2c22696e7af9e7eea1fa1fd10a1f785_1841892e9df07039bbe4c3a55d11026a_finalresults';

% 'SVM 52dim feat, ID-sampling'
pca52 = 'runlog_7d5fafec0dc504215acc8cb7a9202a56_1841892e9df07039bbe4c3a55d11026a_finalresults';
% ---
% NOTE: all 4 test-set runs have exactly the same result 
% ---
run1 = -1;
run2 = -1;
mode = 'join_datasets'; % '', 'avgbase', 'join_datasets'

'AllAvg vs Pca12'
[p, med, avg] = test_generic_significance_signrank(allavg,run1,pca12,run2,0,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

'AllAvg vs pca52'
[p, med, avg] = test_generic_significance_signrank(allavg,run1,pca52,run2,0,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

'Pca12 vs pca52'
[p, med, avg] = test_generic_significance_signrank(pca12,run1,pca52,run2,0,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);


%%
% ------------------------------ Algorithms Weighted Training Weighted Performance Compared 
'MLR t:w,e:w vs euclidean t:w,e:w'
% ---
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_3cdcca7596fed97f87b0ec051cb8bba0_finalresults';

% euclidean baseline, file same as the unweighted above
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1a9788c5e14f30e23ed2a05dbf513c9f_finalresults';
% ---
% NOTE: using the "weighted" parameter here
% ---
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,  1   ,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

%%
'DMLR t:w,e:w vs euclidean t:w,e:w'
% ---
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_1cc76d534804229cbdec8b20f8b75dba_finalresults';

% euclidean baseline, file same as the unweighted above
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1a9788c5e14f30e23ed2a05dbf513c9f_finalresults';
% ---
% NOTE: using the "weighted" parameter here
% ---
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,  1   ,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

%%
'SVM t:w,e:w vs euclidean t:w,e:w'
% ---
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_9bd9ccddb2e4e622e2ba9826466442ba_finalresults';

% euclidean baseline, file same as the unweighted above
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1a9788c5e14f30e23ed2a05dbf513c9f_finalresults';
% ---
% NOTE: using the "weighted" parameter here
% ---
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,  1   ,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

%%
% ------------------------------ Algorithms Weighted Training UNWEIGHTED Performance Compared 
'MLR t:w,e:uw vs euclidean t:w,e:uw'
% ---
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_3cdcca7596fed97f87b0ec051cb8bba0_finalresults';

% euclidean baseline, file same as the unweighted above
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1a9788c5e14f30e23ed2a05dbf513c9f_finalresults';
% ---
% NOTE: using the "weighted" parameter here
% ---
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,  0   ,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

%%
'DMLR t:w,e:uw vs euclidean t:w,e:uw'
% ---
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_1cc76d534804229cbdec8b20f8b75dba_finalresults';

% euclidean baseline, file same as the unweighted above
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1a9788c5e14f30e23ed2a05dbf513c9f_finalresults';
% ---
% NOTE: using the "weighted" parameter here
% ---
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,  0   ,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

%%
'SVM t:w,e:uw vs euclidean t:w,e:uw'
% ---
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_9bd9ccddb2e4e622e2ba9826466442ba_finalresults';

% euclidean baseline, file same as the unweighted above
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1a9788c5e14f30e23ed2a05dbf513c9f_finalresults';
% ---
% NOTE: using the "weighted" parameter here
% ---
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,  0   ,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);


%%
% ------------------------------ Algorithms w / uw Training WEIGHTED Performance Compared 
'MLR t:w,e:w vs MLR t:uw,e:w'
% ---
% MLR t:w,e:w
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_3cdcca7596fed97f87b0ec051cb8bba0_finalresults';

% MLR t:uw,e:w
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1a58077f1232c33b787b661039df107d_finalresults';
% ---
% NOTE: using the "weighted" parameter here
% ---
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,  1   ,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

%%
% ---
'SVM t:w,e:w vs SVM t:uw,e:w'
% ---
% SVM t:w,e:w
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_9bd9ccddb2e4e622e2ba9826466442ba_finalresults';

% SVM t:uw,e:w
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_1841892e9df07039bbe4c3a55d11026a_finalresults';
% ---
% NOTE: using the "weighted" parameter here
% ---
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,  1   ,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);

%%
% ------------------------------ Algorithms w / uw Training WEIGHTED Performance Compared 
'DMLR t:w,e:w vs DMLR t:uw,e:w'
% ---
% DMLR t:w,e:w
file1 = 'runlog_0b506247a68167addf97fcb0296650eb_1cc76d534804229cbdec8b20f8b75dba_finalresults';

% DMLR t:uw,e:w
file2 = 'runlog_0b506247a68167addf97fcb0296650eb_bf08b16f453683d96ddffc31c6439730_finalresults';
% ---
% NOTE: using the "weighted" parameter here
% ---
[p, med, avg] = test_generic_significance_signrank(file1,run1,file2,run2,  1   ,mode);
fprintf('p = %3.4f, median = %3.4f, avg = %3.4f \n\n',p,med,avg);
