function [clips, score] = get_similar_clips(extid, sim, sim_ids)
% clips = get_similar_clips(id, sim, sim_id)
%
% searches for similar clips for clip with base_id id
%

if nargin < 3
    warning 'no similarity id codebook given'
    sim_ids = 1:size(sim,1);
end

% get internal clip id
id = find(sim_ids == extid);

if isempty(id) 
    error 'no similarity data available'
end

clips = [find(sim(id,:) ~= 0)]; 

% get clip scores
score = sim(id,clips);

clips = sim_ids(clips);
