% --
% This class loads and hanles the aufdio features included with the MTT
% Library
% --- 


classdef AudioFeatureRAW < MTTAudioFeature & handle
    
    
    properties(Constant = true)
        
    end
    
    properties
        % ---
        % Set default parameters
        % ---
        my_params = struct([]);
        
    end
    % ---
    % member functions
    % ---
    methods
        
        % ---
        % constructor: pointer to feature in database
        % ---
        function feature = AudioFeatureRAW(varargin)

           feature = feature@MTTAudioFeature(varargin{:});

        end
        
        function [a1, a2, a3] = visualise(feature)
        % ---
        % plots the different data types collected in this feature
        % ---
            for i = 1:numel(feature)
                clip = feature(i).data.info.owner;
                
                % ---
                % labels for chroma data
                % ---
                chroma_labels = {'c', 'c#', 'd','d#', 'e', 'f','f#', 'g','g#', 'a','a#', 'b'};
                mode_labels = {'minor', 'major'};
                
                % hange labels to reflect detected mode
                chroma_labels{feature(i).data.key + 1} = ...
                    sprintf('(%s) %s',mode_labels{feature(i).data.mode + 1}, chroma_labels{feature(i).data.key + 1});
                
              
                secs = [feature(i).data.sections_start; feature(i).data.sections_duration];
                
                h = figure;
                
                % number of subplots
                n = 3;
                    
                % ---
                % chroma feature display
                % ---
                subplot(n,1,1);
                
                % get segment times and fix for same lengths for all plots
                % ---
                % NOTE: Last segment will appear longer
                % ---
                segments = [feature(i).data.segments_start];
                segments(end) = feature(i).data.duration;
                
                % display chroma vectors
                uimagesc(segments, 0:11, [feature(i).data.segments_pitches]);
                
                set(gca,'YTick',[0:11], 'YTickLabel', chroma_labels);
                
                axis xy
                colormap(hot)
                %colorbar;
                ylabel('chroma class');
                title(sprintf('clip %d: %s by %s, chromagram', ...
                    clip.id, clip.title(),clip.artist()));
                
                % added sections
                axis([0 feature(i).data.duration -1 11.5]);
                hl = line([secs(1,:); sum(secs,1)],ones(2, size(secs,2)) * -0.8);
                set(hl,'LineWidth',6);

                a1 = gca;

                % ---
                % mfcc feature display
                %
                % NOTE: the first position of timbre is reduced in energy,
                % as this seems to introduce some corruption in lots of data
                % ---
                timbre = feature(i).data.segments_timbre(:,1);
                timbre = timbre/ max(max(abs(timbre))) * ...
                    mean( mean( abs( feature(i).data.segments_timbre(:,2:min(end,5)))));
                
                subplot(n,1,2);
                uimagesc(segments, 0:11, [timbre feature(i).data.segments_timbre(:,2:end)]);

                axis xy
                %colorbar;
                xlabel('time[s]');
                ylabel('mfcc coeff');
                title(sprintf('mfcc timbre features'));
                   
                a2 = gca;
                
                % ---
                % beats and sections
                % ---

                subplot(n,1,3);
                axis([0 feature(i).data.duration -0.6 1.2]);

                hl = line([0 feature(i).data.duration],[0 0]);
                set(hl, 'Color','g');
                
                a3 = gca;
                
                if ~isfield(feature.data,'bars');
                    return;
                end
                
                beats = feature.data.beats;
                bars = feature.data.bars;
                tatums = feature.data.tatums;
                % tatums
                hl = line([tatums(1,:); tatums(1,:)],[ones(1, size(tatums,2)) * -0.2; max(-0.1,tatums(2,:))]);
                set(hl,'LineWidth',1);
                set(hl, 'Color','k');
                
                % beats
                hl = line([beats(1,:); beats(1,:)],[ones(1, size(beats,2)) * -0.4; max(-0.1,beats(2,:))]);
                set(hl,'LineWidth',2);
                set(hl, 'Color','b');

                % bars
                hl = line([bars(1,:); bars(1,:)],[ones(1, size(bars,2)) * -0.5; max(-0.1,bars(2,:))]);
                set(hl,'LineWidth',4);
                set(hl, 'Color','r');

                % sections
                hl = line([secs(1,:); sum(secs,1)],ones(2, size(secs,2)) * -0.5);
                set(hl,'LineWidth',6);
                
                ylabel('confidence');                
                title(sprintf('rhythmic features @%3.1f BPM, %d/4 meter',...
                    feature(i).data.tempo, feature(i).data.timeSignature));
                
            end
        end
    end

end