function display_mahalanobis_metric(A, labels)
% display a mala matrix and its stats

if nargin < 2
    labels = num2cell(1:size(A,1));
    
elseif ~iscell(labels)
    
    features = labels;
    labels = features.labels;
end



figure;

% plot matrix
imagesc(A);
axis xy;

% set labels
set(gca,'YTick', 1:numel(labels), ...
    'YTickLabel', labels);
set(gca,'XTick',1:numel(labels), ...
    'XTickLabel', labels);

% ---
% approximate parameter weights: 
%   diagonal and sum(abs(row))
% TODO: make nshow dependend on percentile
% ---

nshow = min(numel(labels), 50);
figure;

% get diagonal values of the Matrix
diagw = abs(diag(A));

% ---
% weight with feature values if possible
% ---
if exist('features','var')
    
    diagw = diagw.* mean(features.vector(),2);
end
    

[diagw, idx] = sort(diagw, 'descend');

% normalise
alld = sum(diagw);

% plot
bar(diagw(1:nshow)./ alld);
set(gca,'XTick',1:nshow, ...
    'XTickLabel', labels(idx(1:nshow)));

ylabel ('relevance factor');

if exist('features','var')
    xlabel 'normalised weight'
else
    xlabel 'matrix factors'
end

end