function [dis_s12 dis_s13] = conv_euclidean_dist(index_list,vector_list,index_map,w,norm)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% compute the distance vector from 2 vector using convolution euclidean         %
% w = convolution window                                                        %
% sontran2013                                                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
s_num = size(index_list,1);
s_len = size(vector_list,2);

dis_s12 = zeros(s_num,s_len);
dis_s13 = zeros(s_num,s_len);

% Convert list of assigned indices to ordered indices
[checker index_list] = ismember(index_list,index_map);
cv_vec = ones(1,w);
if all(all(checker(:,1:3)))
  dis_s12 = sqrt(conv2([1],cv_vec,(vector_list(index_list(:,1),:) - vector_list(index_list(:,2),:)).^2));
  dis_s13 = sqrt(conv2([1],cv_vec,(vector_list(index_list(:,1),:) - vector_list(index_list(:,3),:)).^2));
  % dis_s12 = dis_s12(:,w:end-w);
  % dis_s13 = dis_s13(:,w:end-w);
  if norm      
      dis_s12 = dis_s12./(conv2([1],cv_vec,ones(s_num,s_len)));
      dis_s13 = dis_s13./(conv2([1],cv_vec,ones(s_num,s_len)));
  end
else
  fprintf('Some indices are not mapped\n');
end
end