function [out, equal, singles, valid] = metric_fulfills_ranking(met, Y, clips)
%  out = sim_fulfills_ranking(met, Y, ids)
%
% outputs (0-1) percentage of ranking constraints 
% completely fulfilled by the given distance measure

% ---
% for each valid query, check if the ranking is fulfilled
% we also count eeventswhere the distance is equal
% ---
valid = ~(cellfun(@isempty, Y(:,1)) | cellfun(@isempty, Y(:,2)));

equal = 0; 
singles = false(size(Y,1),1);
for i = 1:size(Y,1)
    
    if valid(i)
        
        if numel(Y{i,1}) == 1 && numel(Y{i,2}) == 1 
        % ---
        % Efficient singular ranking comparison
        % using met.distance(clipa,clipb)
        % ---
        % NOTE: by using the < here, we loose half of the 
        % examples which have been same distance and 
        % randomly positioned in earlier runs :(
        % ---
            distgood = met.distance(clips(i), clips(Y{i,1}));
            distbad = met.distance(clips(i), clips(Y{i,2}));
            
            singles(i) = distgood < distbad;
            if distgood == distbad
                equal = equal + 1;
            end
        else
            % ---
            % NOTE: Only reactivated for testing of 
            % outdated similarity data
            % ---
            
            warning 'code only for outdated similarity data\n';

            % ---
            % NOTE: this code is analogous to the above
            % ---
             singles(i) = 1;
             for j=1:numel(Y{i,1})
                 for k = 1:numel(Y{i,2})
                     
                    % ---
                    % All the entries in Y(i,1) have to come before
                    % the ones in Y(i,2)
                    % ---
                    distgood = met.distance(clips(i), clips(Y{i,1}(j)));
                    distbad = met.distance(clips(i), clips(Y{i,2}(k)));
                    singles(i) = singles(i) && (distgood < distbad);
                    
                    % count equalities
                    if distgood == distbad
                        equal = equal + 1;
                    end
                    if ~singles(i)
                        break;
                    end
                 end
             end
             
             
        end
    else
    end
end


out(1) = mean(singles(valid));
if size(Y,2) == 3
    % ---
    % weighted sum of singles: count satisfied votes
    % ---
    weights = cell2mat( Y( valid, 3));
    out(2) = sum(weights(singles(valid))) / sum(weights);
else
    out(2) = -1;
end
out = out';

% markup invalid rankings
% singles(~valid) = -1;


