function [artist_mbid,artist_found, out] = mb_retrieve_artist_id_from_album_info(artist,album)

% http://www.musicbrainz.org/ws/2/recording?query=%22we%20will%20rock%20you%22%20AND%20arid:0383dadf-2a4e-4d10-a46a-e9e041da8eb3 
% call python function
str = python('mbid_from_artist_album.py',artist,album)

% parse text function output
artists = textscan(str,'%s %s','Delimiter','\n');
mbids = artists{2};
artist_found = artists{1}{1};

% song info API
% url = sprintf('http://www.musicbrainz.org/ws/2/recording?query=%s',urlencode(sprintf('%s AND artist:%s',album,artist)));
url = sprintf('http://www.musicbrainz.org/ws/2/release/%s?inc=artists',urlencode(mbids));

[status] = wget(url,' --no-verbose -U firefox -O tmp.xml');
out = xml2struct('tmp.xml');

isrc = [];
artist_mbid = [];

try
artist_mbid = out.metadata.release.artist_dash_credit.name_dash_credit.artist.Attributes.id;
catch
end

