# gets data from the last.fm webservice and 

import pylast
import sys
import fm_network

network = fm_network.get_network()

# now you can use that object every where
if sys.argv[2] == '0':
    artist = network.get_artist(sys.argv[1])
else:
    artist = network.get_artist_by_mbid(sys.argv[1])

# retrieve artist tags
tags = artist.get_top_tags()

# put in comma separated list
for tag in tags[:-1]:
    print(tag.item.get_name().encode('utf-8','ignore')+ ', ' + tag.weight.encode('utf-8','ignore'))

if len(tags) > 0:
    print(tags[-1].item.get_name().encode('utf-8','ignore') + ', ' + tags[-1].weight.encode('utf-8','ignore'))

else:
    print(-1)
