function [tags, tag_weight] = fm_retrieve_artist_tags(artist_name,bymbid)
%[tags, tag_weight] = fm_get_artist_tags(artist_name,bymbid)
% 
% artist_name: either artist name string, or
%              musicbrainz artist id with bymbid == 1
% 
% returns last.fm artist tags and tag weights for given artist
% this uses a lastpy python script to handle the REST data exchange

if nargin < 2
    bymbid = '0';
else
    bymbid = num2str(bymbid); 
end

% call python function
tagstr = python('fm_retrieve_artist_tags.py',artist_name,bymbid);

% parse text function output
tags = textscan(tagstr,'%s %d','Delimiter',',');
tag_weight = tags{2};
tags = tags{1};