function [fmartist_name, fmartist_name_names] = fm_corresponding_artists(artists)
%[artists, fmartists] = fm_corresponding_artists(artists)
%
% searches last.fm for the artist given in a cell 
% array of strings and saves the first hit into the output.
%
% returns -1 of no matches found
maxtry = 10;

% artists = unique(artists);
i = 1;
numtry = 0;
while i <= numel(artists)
    
    % ---
    % as sometimes this fails due to connection problems
    % or other problems not yet identified, we TRY
    %
    % for fails, we may try one time again!
    % ---
    fprintf('%d percent: %s\n',floor(i*100/numel(artists)),char(artists{i}));
    try 
        [tmp, tmpid] = fm_retrieve_album(char(artists{i}));
        fmartist_name(i,:) = {artists{i}, tmp{1}, tmpid{1}};
    catch err
        
        % no work :(
        warning(err.message);
        fmartist_name(i,:) = {artists{i}, '-1', '-1'};
        
        numtry = numtry + 1;
        
        % ---
        % NOTE: we try gain in case it fails for < maxtry times
        % ---
        if numtry < maxtry
            i = i - 1;
        else
            numtry = 0;
        end
    end
    i = i + 1;
end

fmartist_name_names = {'magnatagatune_album', 'fm_album', 'mbid'};