% --
% This class loads and hanles the aufdio features included with the MTT
% Library
% --- 
classdef MTTRandomFeature < MTTAudioFeature & handle
    
    properties(Constant = true)
        
        my_revision = str2double(substr('$Rev: 167 $',  5, -1));
    end
    
    properties
        
        % ---
        % Set default parameters
        % ---
        my_params = struct(...
            'nrandoms', 100 ...
            );
    end
    % ---
    % member functions
    % ---
    methods
        
        % ---
        % constructor: pointer to feature in database
        % ---
        function feature = MTTRandomFeature(varargin)

            feature = feature@MTTAudioFeature(varargin{:});
        end
        
        % ---
        % load feature data from xml file
        % ---
        function data = extract(feature, clip)
        % load feature data by parsing xml
            
            global globalvars;
        
            % fprintf('parsing features for clip %d \n',clip.id());
            
            % parse feature
            data.random = rand(feature.my_params.nrandoms, 1);

            % save info data
            data.info.type = 'MTTRandomFeature';
            data.info.owner_id = clip.id;
            data.info.creatorrev = feature.my_revision;
            
            % save param data
            data.info.params = feature.my_params;
            
            % prepare field for final features
            data.final.vector = data.random;
            data.final.dim = numel(data.final.vector);
             
            info = {'random'};
            info(2:data.final.dim) = num2cell(2:data.final.dim);
            data.final.vector_info.labels = info;
        end
                
        function  visualise(feature)
        % ---
        % plots the different data types collected in this feature
        % ---

        end
    end
end
