classdef MTTMixedFeatureSlaney08GenreBasicSm < MTTAudioFeature & handle
    % ---
    % 
    % 
    % The usual worklow for these features constist of three steps
    % 1. extract: extracts the basic single-file dependent features
    % 2. define_global_transform: calculates the global feature
    %       transformation parameters
    % 3. finalise: applies the common transformations to a specific feature
    % ---
    
    properties(Constant = true)
        
        % svn hook
        my_revision = str2double(substr('$Rev$',  5, -1));
    end
       
    properties
        % ---
        % Set default parameters
        % ---
        my_params = MTTAudioFeature.inherited_params(...
            'MTTMixedFeatureGenreBasicSm', ...
            ... % ---
            ... % following are Slaney08 parameters
            ... % --- 
            'norm_mttstats', 1, ... % 
            'whiten_mttstats', 0, ... % NOTE: whitening as in slaney?? 
            'select_mttstats', 1 ...% select certain features
        );
    end
    
    % ---
    % member functions
    % ---
    methods
        
        % ---
        % constructor: pointer to feature in database
        % ---
        function feature = MTTMixedFeatureSlaney08GenreBasicSm(varargin)

            feature = feature@MTTAudioFeature(varargin{:});
        end

        % ---
        % extract feature data by combining genre adn basicsm features
        % ---
        function data = extract(feature, clip)
            
            % ---
            % get MTTMixedFeatureGenreBasicSm this includes possible
            % local normalisations
            % ---
            data.genrebasicsm = clip.features('MTTMixedFeatureGenreBasicSm',feature.my_params);
            
            % ---
            % get genre tag features
            % ---
            
            data.mttstats = clip.features('MTTAudioFeatureSlaney08',feature.my_params);
            
            
            % prepare field for final features
            data.final.vector = [];
            data.final.vector_info = struct(); 
            data.final.dim = 0;
           
            % save info data
            data.info.type = class(feature);
            data.info.owner_id = clip.id;
            data.info.creatorrev = feature.my_revision;
            
            % save parameters
            data.info.params = feature.my_params;
        end
        
        function define_global_transform(features)
        % calculate and set normalization factors from the group of 
        % input features. These features will be set for the full database
        
            if numel(features) == 1
                error ('Insert feature array for this method');
            end
            
            % ---
            % We collect all the relevant genrebasicsm 
            % features and get the transform on this basis.
            % ---
            for i = 1:numel(features)
            	genrebasicsm(i) = features(i).data.genrebasicsm;
            end
            
            % call the features own transsform function
            genrebasicsm.define_global_transform();
            
            % ---
            % We collect all the relevant mttstats 
            % features and get the transform on this basis.
            % ---
            for i = 1:numel(features)
            	mttstats(i) = features(i).data.mttstats;
            end
            
            % call the features own transsform function
            mttstats.define_global_transform();
            
            % ---
            % set common feature values for mixed features
            % ---
            features(1).my_db.set_common([1]); %trivial common
        end
        
        
        function finalise(feature)
        % applies a final transformation and collects the 
        % information of this feature within a single vector
        % see info for types in specific dimensions

            for i = 1:numel(feature)
                
                % check for neccesary parameters
                if isempty(feature(i).my_db.commondb)

                    error('Define the global transformation first');
                end
                
                % ---
                % final data assembly
                % ---
                % concatenate vectors
                feature(i).data.final.vector = ...
                    [feature(i).data.genrebasicsm.vector() ;...
                    feature(i).data.mttstats.vector()];
                
                % add up feature dimensions
                feature(i).data.final.dim = feature(i).data.genrebasicsm.dim...
                    + feature(i).data.mttstats.dim;
                
                % concatenate labels
                lbl1 = feature(i).data.genrebasicsm.labels();
                lbl2 = feature(i).data.mttstats.labels();
                feature(i).data.final.vector_info.labels = ...
                    {lbl1{:}, lbl2{:}};
            end
        end
        
        % ---
        % destructor: do we really want to remove this 
        % from the database? No, but 
        % TODO: create marker for unused objects in db, and a cleanup
        %  function
        % ---
        function delete(feature)
            
        end
       
    end
end