function Y = scale_ratings(Y, max_weight)
% [Yout, Xout] = scale_ratings(Y, max_weight)


% get maximal weight 
weights = cell2mat(Y(:,3));
max_dataweight = max(weights);

valid = ~(cellfun(@isempty, Y(:,1)) | cellfun(@isempty, Y(:,2)));

% scale weights to a maximal value of max_weight
for i = 1:size(Y, 1)
     if valid(i) &&  Y{i,3} > 0
        Y{i,3} = min(max_weight, max(1, round((Y{i,3} / max_dataweight) * max_weight)));
     end
end