% ---
% fake partitioning for comparison 
% to stober08:
% ---
classdef cvpartition_alltrain
  
properties (Hidden)

    mtest;
    mtraining;
end
properties
    N;
    NumTestSets;
    TrainSize;
    TestSize;
end
    
        
methods 
    
% ---
% constuctor: directly calculates the truncated testset
% ---
function P = cvpartition_alltrain(nData, nRuns)
    
    P.NumTestSets = nRuns;
    P.N = nData; 

    % build training and test sets
    for i = 1:P.NumTestSets
        P.TrainSize(i) = nData;
        P.TestSize(i) = nData;
        P.mtraining{i} = ones(P.N, 1);
        P.mtest{i} = ones(P.N, 1);
    end
end

function out = test(P, i)

    out = P.mtest{i};
end

function out = training(P, i)

    out = P.mtraining{i};
end

end  
end