function L = lowest_fenergy(V,W,visB,hidB,Classes)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Return the labels L(Classes) to the lowest energy softmax unit      %   
% visP: hidden states                                                %
% visN: reconstructed data (with softmax)                            %
% WW = [W visB hidB]                                                 %
% F(v) = -\sum_i v_ia_i - \sum_jlog(1+e^(x_j))                       %
% -*-sontran2012-*-                                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lNum = size(Classes,2);
sNum = size(V,1);
F = zeros(sNum,lNum);
out = zeros(sNum,lNum);
for i=1:lNum
    F(:,i) = 1;
    X = [V F]*W + repmat(hidB,sNum,1);
    out(:,i) = sum(repmat(visB,sNum,1).*[V F],2) + sum(log(1+exp(X)),2);
    F(:,i) = 0;
end
L =  softmax2discrete(out,Classes);
end

