function [mod] = new_rbm(hidNum,type)
% computes a new RBM that can be used instead of the saved ones

conf.hidNum = hidNum;
conf.eNum   = 150;
conf.bNum   = 1;
conf.gNum   = 1;
conf.N    = 80;
conf.MAX_INC = 10;
 
% use the specific parameters from the paper
switch type

    case 'svm' 
        conf.params = [0.7 0.7 0.1 2.0e-5];
    case 'grad'
        conf.params = [0.05 0.1 0.1 2.0e-5];
    otherwise 
end

% load data
feature_file = 'rel_music_raw_features+simdata_ISMIR12';
vars = whos('-file', feature_file);
A = load(feature_file,vars(1).name,vars(2).name,vars(3).name,vars(4).name);
data = A.(vars(1).name);
conf.sNum   = size(data,1);

mod = struct();
[mod.W_max{1} mod.vB_max{1} mod.hB_max{1}] = training_rbm(conf,zeros(0,0),feature_file);

