function write_mat_results_ismir12(filein, subrun, fileout)
% write_mat_resutls_ismir12(filein, subrun, fileout)
%
% write results from result file into ismir12 generic format.
% if subrun is a vector, the results are averaged over the 
% runs specified


[out, stats, features, individual] = test_generic_display_results(filein, 0);

% ---
% we get the single individual values and 
% ---
for i = 1:numel(subrun)
    individual = individual(subrun);
    
    % number of inctrain cycles
    n_inctrain = numel(individual.diag.inctrain);

    % ---
    % ok_train_unused
    % ---
    values_ok_train_unused{i} = reshape([individual.diag.inctrain.ok_notin_train], [],n_inctrain);
    values_ok_train_unused{i} = values_ok_train_unused(1:2:end,:).*100;

    mean_ok_train_unused{i} = mean(values_ok_train_unused, 1);
    var_ok_train_unused{i} = var(values_ok_train_unused,[], 1);

    % ---
    % ok_train
    % ---
    values_ok_train{i} = reshape([individual.diag.inctrain.ok_train], [],n_inctrain);
    values_ok_train{i} = values_ok_train(1:2:end,:).*100;

    mean_ok_train{i} = mean(values_ok_train, 1);
    var_ok_train{i} = var(values_ok_train,[], 1);

    % ---
    % ok_test
    % ---
    values_ok_test{i} = reshape([individual.diag.inctrain.ok_test], [],n_inctrain);
    values_ok_test{i} = values_ok_test(1:2:end,:).*100;

    mean_ok_test{i} = mean(values_ok_test, 1);
    var_ok_test{i} = var(values_ok_test,[], 1);
end



clear ('out', 'stats', 'features', 'individual');
save(fileout)
