function [idx, strpos] = substrcellfind(strdb, str, findAll)
% [idx, strpos] = substrcellfind(strdb, str)
% 
% finds a string within an cell array of strings
% only outputs the first occurence, unless
% findAll is set to true
%
% substrcellfind is NOT CASE sensitive

if nargin < 3
    findAll = 0;
end

idx = [];
strpos = [];
for i = 1:length(strdb)
    
    % search string in cell db
    tpos = strfind(lower(char(strdb{i})), lower(str));
    
    if ~isempty(tpos)
        
        strpos(end+1) = tpos;
        
         if ~findAll

            idx = i;
            return;
        else
            idx(end+1) = i;
        end
    end
end

% if isempty(idx) 
%     idx = -1;
% end
