function out = makro_import_magnatagatune_mbtags();
load db.mat
clip_info_proper_names
cnt_workd = 0;

mbtagdb = AnnotDB();

failedartists = [];

for i = 1:size(clip_info_proper,1)
    % ---
    % get internal artist id
    % ---
    artistintid = artistdb.get_annot_id(lower(clip_info_proper{i,4}));
        
    % do we have an mbid if not skip?
    if isempty(clip_info_proper{i,12}) || strcmp(clip_info_proper{i,12}, '-')
        continue;
    end

    % do we have tags for this artist?
    if ~isempty( mbtagdb.annotids_for_owner(artistintid)) || sum(failedartists== artistintid)> 0;
        continue
    end

    try
        % ---
        % ok, lets get the tags
        % ---
        [tags,count, out] = mb_retrieve_tags_for_artist_id(clip_info_proper{i,12});

        if ~isempty(tags)
            cprint(0,'loaded info for %s: found %s, %s',clip_info_proper{i,4},artist_found,artist_mbid);

            % ---
            % TODO: save tags in map
            % ---
            for i=1:numel(tags)
                mbtagdb.add_pair(artistintid, tags{i}, count(i));
            end
            cnt_workd = cnt_workd + 1;

        else
            cprint(0,'no tags received for %s:%s',clip_info_proper{i,4});
             % TODO: mark no tags received for this
             failedartists(end+1) = artistintid;
        end
        pause(1)
    catch
    end
  
end

failedartists
numel(failedartists);
clear failedartists
save ('db.mat','mbtagdb','-append')
