
% profile clear;
% profile on;

clear eval;
N = 20;
for ci = 1:N
    order = ci;
    % connectivity = ceil(rand(1) * order)
    % E = mk_rnd_dag(order, connectivity);
    E = rand(order) > exp(1) * rand(1);

    G = DiGraph(ones(order,1), E);
    eval.G(ci) = G;
    
    eval.res_naive(ci) = acyclic(E);
    
    eval.res_myfun(ci) = G.isAcyclic;
    
    Gstob = ClipSimGraphStober(G);
    
    eval.res_stober(ci) = Gstob.isAcyclic;
end
eval


figure
plot([eval.res_naive' eval.res_myfun'+0.1 eval.res_stober'+0.2],'*')
legend naive myfun stober
axis([0 N  -1 2 ])
% profile viewer;

%%
% ---
% Comparison of implementations on magnatagatune dataset
% ---

% Stober Graph
Gstob = ClipSimGraphStober();

% Cast into matlab Graph
GstobG = Gstob.to_DiGraph;

% My Multigraph reimplementation
Gm = ClipSimGraphMulti(comparison, comparison_ids);

GstobG == Gm % TRUE - the converted Graph exactly resembles my extracted one

Gm.isAcyclic % FALSE
GstobG.isAcyclic % FALSE

Gstob.isAcyclic % TRUE (this is wrong, there are a lot of length-2-cycles)

% ---
% Ok, now remove length 2 cycles
% ---
Gm.remove_cycles_length2 % matlab cycle remover
Gstob.remove_cycles_length2 % stober cycle remover

GstobGnocycles = Gstob.to_DiGraph();

GstobGnocycles == Gm % TRUE - we remove the same edges

% ---
% NOTE: There are no cycles left
% after removing length 2 cycles
% ---
GstobGnocycles.isAcyclic % TRUE

Gstob.isAcyclic % FALSE inconsistent wrong result(compare with above)


%% Finds the actual defective cycle

Gstob = ClipSimGraphStober();
Gstob.remove_cycles_length2

GstobG = Gstob.to_DiGraph();
Gstob.isAcyclic

N = GstobG.node('227:45936');

[Gs] = GstobG.connected_components(N);
Gs.visualise

% ---
% Search same node in my Multigraph reimplementation
% ---
Gm = ClipSimGraphMulti(comparison, comparison_ids);
Gm.remove_cycles_length2
Nm = Gm.node(227,45936);

[Gsm] = Gm.connected_components(Nm);
Gsm.visualise