function [fmalbums, fmalbum_names] = fm_corresponding_albums(albums)
%fmalbums = fm_corresponding_albums(albums)
%
% searches last.fm for the artist given in a cell 
% array of strings and saves the first hit into the output.
%
% fmalbum_names = {magnatagatune_artist, fm_artist};
%
% returns -1 of no matches found
maxtry = 3;

albums = unique(albums);
i = 1;
numtry = 0;
while i < numel(albums)
    
    % ---
    % as sometimes this fails due to connection problems
    % or other problems not yet identified, we TRY
    %
    % for fails, we may try one time again!
    % ---
    fprintf('%d percent: %s\n',floor(i*100/numel(albums)),char(albums{i}));
    try 
        [tmp, tmpid] = fm_retrieve_album(char(albums{i}));
        fmalbums(i,:) = {albums{i}, tmp{1}, tmpid{1}};
    catch err
        
        % no work :(
        warning(err.message);
        fmalbums{i} = '-1';
        
        numtry = numtry + 1;
        
        % ---
        % NOTE: we try again in case it fails for < maxtry times
        % ---
        if numtry < maxtry
            i = i - 1;
        else
            numtry = 0;
        end
    end
    i = i + 1;
end

fmalbum_names = {'magnatagatune_album', 'fm_album', 'mbid'};
