% ---
% This is the wrapper and loader class for magnatagatune db
% and related data
% ---

classdef MTTClipDB < handle
    
    properties (SetAccess = 'private')
        
        % ---
        % TODO: create global "db_magnaclips" class pointer 
        % ---
        
        annots;
        annots_filenames;
        annots_ids;
        annots_names;
        
        % inverse ids for comparison
        comparison_ids;

        clip_info_proper;
        clip_info_proper_names;

%         magnagenre_childof;
        
        % genre database
        genredb;
        
        % artist database
        artistdb;
        
        % tag databses
        tagdb;
        
        fmtagdb;
        
        % @todo: get data
        mbtagdb;
    end
    
    properties (Hidden)
    % hidden properties

    end
    
    methods
        
        % ---
        % constructore
        % ---
        function db = MTTClipDB()
            
            % ---
            % TODO: restructure data /  db.mat
            % ---
            
            load 'db.mat';
            
            db.annots = annots;
            db.annots_ids = annots_ids;
            db.annots_names =  annots_names;
            db.annots_filenames = annots_filenames;
                        
            % comparison ids
            db.comparison_ids = sparse(comparison_ids,1, 1:numel(comparison_ids));

            db.clip_info_proper = clip_info_proper;
            db.clip_info_proper_names = clip_info_proper_names;
            
            % Genre in new structure for textual annotations
            db.genredb = AnnotDB(magnagenres, clip_magnagenres, annots_ids);
            
            % Artist for each clip
            db.artistdb = artistdb; %AnnotDB('clips_by_annot', db.clip_info_proper(:, 4), annots_ids);
            
            % Magnatagatune Tags
            db.tagdb = tagdb; % AnnotDB(annots_names, annots, annots_ids);
            
            % Last Fm Tags
            db.fmtagdb = fmtagdb; % LFMTagsDB(db.artistdb);
            
            % musicbrainz tags
            db.mbtagdb = mbtagdb; % LFMTagsDB(db.artistdb);
            
%             db.clip_magnagenres = clip_magnagenres;
%             db.magnagenres = magnagenres;
%             db.magnagenre_childof = magnagenre_childof;

        end
        
        % ---
        % member functions
        % ---
        function out = genres(db)
        % returns the magnatune genre list
            
            out = db.genredb.lexicon;
        end
        
        function clips = clips_by_genre_name(db, name)
        % returns all clips having the assigned genre
        
            clips = MTTClip( db.genredb.owner( name));   
        end
        
        function out = tags(db)
        % returns the magnatune artist list
            
            out = db.tagdb.lexicon;
        end

        
        function out = artists(db)
        % returns the magnatune artist list
            
            out = db.artistdb.lexicon;
        end
        
        function clips = clips_by_artist_name(db, name)
        % returns all clips having the assigned artist
            
            clips = MTTClip( db.artistdb.owner( name));   
        end
    end
    
    % ---
    % Hidden Methods
    % ---
    methods (Hidden = true, Access = private)
        
        function out = clips_by_genre(db, genre_id)
            % returns clip ids given a genre id
            
            pos = (db.clip_magnagenres(:,genre_id) == 1);
            
            % return clip ids, not pos
            out = db.annots_ids(pos);
        end
    end
end