% --
% This class loads and hanles the aufdio features included with the MTT
% Library
% --- 


classdef MTTAudioFeatureRAW < AudioFeatureRAW & handle
    
    
    properties(Constant = true)
        
        my_revision = str2double(substr('$Rev: 2284 $',  5, -1));
    end
    
    properties
        % ---
        % Set default parameters
        % ---
        
    end
    % ---
    % member functions
    % ---
    methods
        
        % ---
        % constructor: pointer to feature in database
        % ---
        function feature = MTTAudioFeatureRAW(varargin)

            feature = feature@AudioFeatureRAW(varargin{:});

        end
        
        % ---
        % load feature data from xml file
        % ---
        function data = extract(feature, clip)
        % load feature data by parsing xml
            
            global globalvars;
        
            % fprintf('parsing features for clip %d \n',clip.id());
            
            % parse feature
            data = xml_parse_mtt(clip.featurefile_full());
            
            % precombine the segmentst information for better
            % interoperability with MSD data later
            
            data.segments_pitches = [data.segments(:).pitches];
            data.segments_timbre = [data.segments(:).timbre];
            
            data.segments_duration = [data.segments(:).duration];
            data.segments_start = [data.segments(:).start];
            
            data.sections_start = [data.sections(:).start];
            data.sections_duration = [data.sections(:).duration];
            
            data.segments_duration =  [data.segments(:).duration];

            data.segments_loudness_max_time = [data.segments(:).loudness_max_time];
            data.segments_loudness_max = [data.segments(:).loudness_max];
            data.segments_loudness = [data.segments(:).loudness];

            % ---
            % TODO: feature.data.bars
            % ---
            [data.bars, data.beats, data.tatums] = MTTAudioFeatureRAW.infer_bar_times(data.bars);
            
            % save info data
            data.info.type = 'MTTAudioFeatureRAW';
            data.info.owner = clip;
            data.info.owner_id = clip.id;
            data.info.creatorrev = feature.my_revision;
            
            data.info.params = feature.my_params;
        end
    end
    
    methods(Static)
    function [bars, beats, tatums] = infer_bar_times(bar)
        % [bars, beats, tatums] = infer_bar_times(feature)
        %
        %  extract bar and beat starting times from tatums            
            beats = [];
            bars = [];
            tatums = [];
            
            % bars
            for i = 1:numel(bar)
                % beats
                for j = 1:numel(bar(i).beat)
                    %  tatums
                    for k = 1:numel(bar(i).beat(j).tatum)
                        tatum = bar(i).beat(j).tatum(k);
                        
                        % collect tatums and confidence
                        tatums(1:2,end+1) = [tatum.time,tatum.confidence];
                        

                        % ---
                        % save beat if  this is the first tatum in it
                        % ---
                        if k == 1
                            beats(1:2,end+1) = [tatum.time,...
                               bar(i).beat(j).confidence];
                           
                            % ---
                            % save bar if this is the first tatum in it
                            % ---
                            if j == 1
                                bars(1:2,end+1) = [tatum.time,...
                                   bar(i).confidence];
                            end
                        end
                        
                        
                    end
                end
            end
            
        % end function
        end    
    end
    
end