% ---
% This is the wrapper and loader class for Last.Fm db
% and related data
% ---

classdef LFMTagsDB < handle
    
    properties
       
       % connects the last.fm artists to MTTartist ids
       matching_artists;
       
       % saves the last fm tags for last.fm artist ids
       tagdb;
    end
    
    properties(Dependent)
        
       lexicon;
    end
    
    
    methods
        function db = LFMTagsDB(artistdb)
            
            % load data
            load last.fm.mat;

            % ---
            % NOTE: here, we save the corresponding magnatagatune
            % artists. There make sure that the last.fm artists 
            % are properly associated!
            %
            % finally, the central last.fm artist index will refer 
            % to both the MTT artist database and the tags
            % ----
            
            % get all the clips artists
            artists = artistdb.lexicon;

            % assign artists to Last.Fm artists
            lexicon = [];
            annots = [];
            
            justfmartists = fmartists(:,2);
            for i = 1:numel(justfmartists)
                
                %get matching MTT for each Last.fm artist
                pos = strcellfind(artists, justfmartists{i});
                
                % save its id 
                if ~isempty(pos)
                    associds(i) = artistdb.get_annot_id(artists{pos});
                end
            end
            
            % ---
            % TODO: assert wheather if the fmartist id actually coincide
            % justfmartists_ids = matching_artists.get_annotid(justfmartists);
            % ---
            
            % call superclass constructor
            db.tagdb = AnnotDB(fmartist_annots_names, ...
                fmartist_annots, associds);
            
            % save the mathing artists
            db.matching_artists = AnnotDB('clips_by_annot', ...
                justfmartists, associds);
            
        end
    end
    
    
    methods
        
       % retrieve annot by clip
       function [out, score, aid] = annots(db, clip)
           
           % ---
           % NOTE: we retrieve the tags for the artist matching the clips
           % one
           % ---
           
           fma_id = db.matching_artists.annotids_for_owner(clip.artist_id());
           
           artist = clip.artist();
           
           if ~isempty(fma_id)
               
                [out, score, aid] = db.tagdb.annots(fma_id);
           else
               warning('Artist %s not found in Last.fm tags DB', artist);
           end
       end 
       
        function out = annotids_for_owner(db, clip)
           
           % ---
           % NOTE: we retrieve the tags for the artist matching the clips
           % one
           % ---
           
           fma_id = db.matching_artists.annotids_for_owner(clip.artist_id());
           
           artist = clip.artist();
           
           if ~isempty(fma_id)
               
                out = db.tagdb.annotids_for_owner( fma_id );
           else
               warning('Artist %s not found in Last.fm tags DB', artist);
           end
        end 
       
        function out = get.lexicon(db)
        % gives back all the tags
            
            out = db.tagdb.lexicon;
        end
    end
    
    methods(Static)
        
        
    end
end
    
    
    