function out = migrate_to_test_dir(varargin)
%
%  out = migrate_to_test_dir('testname', 'this is a test description')
%
% or 
% 
%  out = migrate_to_test_dir('fixedtestdir', 'dirname')
%
% create test run directory, add current dir to path and move
% into test run dir
%
% NOTE: the test directory is created in "globalvars.testdatadir" if set
%

global globalvars;

[sTest,fixedtestdir, unused] = process_options(varargin, ...
                         'testname', '','fixedtestdir', '');

% use starting script name as description if none is given
if isempty(sTest)
    [ST, I] = dbstack();
    sTest = ST(end).name;
end


% switch to test directory, and add this or current dir to path
if ~isempty(globalvars.tstoutputpath) && ~isempty(dir(globalvars.tstoutputpath));
    addpath(globalvars.tstoutputpath);
    cd(globalvars.tstoutputpath);
else
    addpath(pwd);
end

% get camir version
[~,cv] = camirversion();

% get current date
sDate = datestr(now,'yymmdd');

if isempty(fixedtestdir)
    newdir = sprintf('%s_%s_r%d',sDate,sTest,cv);
else
    newdir = fixedtestdir;
end

% create dir if not existent
if isempty(dir(newdir));
   mkdir(newdir);
end

cd(newdir);
if ~isempty(strfind(pwd, newdir))
    out = newdir;
else
    warning 'cannot migrate to specified test directory, Ill dump right here';
    out = -1;
end