function [deltas, idx, weights] = get_fo_deltas(r, X, rectify)
% [deltas, idx, (weights)] = get_fo_deltas(r, X)
% 
% returns the difference vectors (dist(a,c) > dist(a,b)) 
%  for a given ranking: 
%  deltas{i}(:,1) = a - b, deltas{i}(:,2) = a - c; 
%
% set rectify to output absolute values of training examples

if nargin < 3
    rectify = 0;
end

% ---
% NOTE: this preallocation is not complete
% ---
deltas = {};
idx = {};
weights = [];
for i = 1:size(r,1)
    
    % feature index
    a = i;
    
    % check if ranking is valid
    if ~isempty(r{i,1}) && ~isempty(r{i,2})&& ...
        isempty(intersect(r{i,1}, r{i,2}));
    
        % ---
        % NOTE / TODO: the follwing is intended for compability
        %  both sides of the ranking may have more than one entry.
        %  for the MTT database, the ranking may be correct, but the 
        %  inequalities build from non-singular rankings are not
        %  based on the actual data
        % ---
        for j = 1:numel(r{i,1})
            b = r{i,1}(j);
            
            for k = 1:numel(r{i,2})
                c = r{i,2}(k);

                % ---
                % get vector deltas, 
                % NOTE: first: dissimilar, then similar pair
                % ---
                [dac] = X(:,a) - X(:,c);
                [dab] = X(:,a) - X(:,b);

                if ~rectify
                    deltas{end+1} = [dac dab]; 
                else
                    % ---
                    % rectify the data for training
                    % ---
                    deltas{end+1} = abs([dac dab]); 
                end
                
                idx{end+1} = {[a c],[a b]};
                
                % save weights
                if size(r,2) == 3
                    weights(end+1) = r{i,3}(1);
                end
            end
        end
    end
end
end

