% ---
% startup.m  
% this shall become the general camir startup
% ---

% global globalvars;

% use this revision numbers for figures etc!
% globalvars.camir.revision = str2double(substr('$Rev$',  5, -1));
% rev = textscan(evalc('!svnversion'),'%d%s');
% globalvars.camir.revision = double(rev{1});

globalvars.camir.path = pwd;
globalvars.camir.revision = camirversion;

clear rev
globalvars.debug = 0;

% ---
% load MTT database
% ---
global comparison;
global comparison_ids;
load ('db.mat', 'comparison','comparison_ids','comparison_names');


% ---
% load MSD database
% ---            
global MillionSong MSDsubset
MillionSong = globalvars.camir.msd.basepath;
MSDsubset='subset_'; % or '' for full set

globalvars.camir.msd.data_path= [MillionSong,'/data'];
globalvars.camir.msd.addf_path= [MillionSong,'/AdditionalFiles'];
globalvars.camir.msd.addf_prefix= [globalvars.camir.msd.addf_path,'/',MSDsubset];
% Check that we can actually read the dataset


warning off MATLAB:class:cannotUpdateClass

% initialize clip and feature databases

global db_MTTClip;
db_MTTClip = MTTClipDB();

%global db_MSDClip;
%db_MSDClip = MSDClipDB();

% global db_CASIMIRClip;
% db_CASIMIRClip = CASIMIRClipDB();

global db_magnaaudiofeat;         
db_magnaaudiofeat = MTTAudioFeatureDBgen('MTTAudioFeatureRAW');

global db_magnaaudiofeat_basicsm;
db_magnaaudiofeat_basicsm = MTTAudioFeatureDBgen('MTTAudioFeatureBasicSm');

global db_magnatagfeat_genrebasic;
db_magnatagfeat_genrebasic = MTTAudioFeatureDBgen('MTTTagFeatureGenreBasic');

global db_magnamixedfeat_genrebasicsm;
db_magnamixedfeat_genrebasicsm = MTTAudioFeatureDBgen('MTTMixedFeatureGenreBasicSm');

global db_MTTMixedFeatureGenreBasicSmPCA;
db_MTTMixedFeatureGenreBasicSmPCA = MTTAudioFeatureDBgen('MTTMixedFeatureGenreBasicSmPCA');

global db_MTTAudioFeatureSlaney08;
db_MTTAudioFeatureSlaney08 =  MTTAudioFeatureDBgen('MTTAudioFeatureSlaney08');

global db_MTTMixedFeatureSlaney08GenreBasicSm;
db_MTTMixedFeatureSlaney08GenreBasicSm = MTTAudioFeatureDBgen('MTTMixedFeatureSlaney08GenreBasicSm');

global db_MTTMixedFeatureSlaney08GenreBasicSmPCA;
db_MTTMixedFeatureSlaney08GenreBasicSmPCA  = MTTAudioFeatureDBgen('MTTMixedFeatureSlaney08GenreBasicSmPCA');

global db_MTTMixedFeatureGenreRandom;
db_MTTMixedFeatureGenreRandom = MTTAudioFeatureDBgen('MTTMixedFeatureGenreRandom');

global db_MTTMixedFeatureStober11Genre;
db_MTTMixedFeatureStober11Genre = MTTAudioFeatureDBgen('MTTMixedFeatureStober11Genre');

global db_MTTMixedFeatureStober11Slaney08GenreBasicSm;
db_MTTMixedFeatureStober11Slaney08GenreBasicSm = MTTAudioFeatureDBgen('MTTMixedFeatureStober11Slaney08GenreBasicSm');

global db_MTTMixedFeatureSon;
db_MTTMixedFeatureSon = MTTAudioFeatureDBgen('MTTMixedFeatureSon');

global db_AudioFeatureRAW;
db_AudioFeature = MTTAudioFeatureDBgen('AudioFeatureRAW');

%global db_MSDAudioFeatureRAW;
%db_MSDAudioFeatureRAW = MTTAudioFeatureDBgen('MSDAudioFeatureRAW');

global db_MTTMixedFeatureSonRBM;
db_MTTMixedFeatureSonRBM = MTTAudioFeatureDBgen('MTTMixedFeatureSonRBM');
