function [sim, dissim, confidence] = sim_from_comparison_naive(comparison, comparison_ids, symmetrical)
%
%  [sim, dissim, confidence] = sim_from_comparison_naive(comparison)
%
% derives symmetric, absolute similarity measurements
% from relative magnatagatune comparisons
% naive implementation for first tests of the ITML algorithm
%

% reindex comparison for more simple evaluation
% makro_prepare_comparison

% ---
% analyse the number of comparisons for each pair of songs
% ---
[num_compares] = get_comparison_stats(comparison, comparison_ids);

% ---
% in comparison, the outlying piece is highlighted. 
% thus, we naively consider that
% a. both of the remaining pieces are more similar to each other.
% b. the outlier is dissimilar to both of the other pieces
% ---
[outsort, outidx] = sort(comparison(:,4:6),2,'ascend');

% ---
% similarity of the two non-outliers a, b 
% they are similar if both of them have scores way smaller 
% than the outlier c:
% score (a,b) = 1 - (max(a,b)/c)
%
% dissimilarity: clip b is considered more different to clip c than
% a, as clip a seems to share some properties with both songs
% dissim(b,c) = 0.5 + b/(2c)
% ---

sim = sparse(numel(comparison_ids),numel(comparison_ids));
dissim = sparse(numel(comparison_ids),numel(comparison_ids));
for i = 1:size(comparison,1)
    
    % get the outlier votes
    simpair = comparison(i,outidx(i,1:2));
    c = comparison(i,outidx(i,3));
    
    % we want a triangular similarity matrix
    [simpair, simidx] = sort(simpair);
    outsort(i,1:2) = outsort(i,simidx);
    
    % ---
    % save the distance between the second biggest vote and the max vote.
    % NOTE: we bias the vote by dividing through the number of total
    % comparisons for the particular pair of clips
    % ---
    sim(simpair(1), simpair(2)) = sim(simpair(1), simpair(2)) +  ...
        (1 - outsort(i,2) / outsort(i,3)) * (1 / num_compares(simpair(1),simpair(2)));
    
    dissim(simpair(1:2), c) = 0.5 + (outsort(i,1:2) ./ (2 * outsort(i,3)));
end

% ---
% mirror to make matrix symmetrical 
% ---
if nargin == 3 && symmetrical
    sim = sim + sim';
    dissim = dissim + dissim';
end

% ---
% TODO: use number of votes and std or similar to 
% rate the confidence for each similarity mesurement
% ---
confidence = [];

