% --- 
% import isrcs via albums for magnatune clips

% now, we load the new file and search for the information on the 
% actual excerpts we have
% ---
clip_info_proper = db_MTTClip.clip_info_proper;


 db = adodb_connect('Driver={MySQL ODBC 5.1 Driver}; Server=10.2.165.196; Database=test; UID=daniel; PWD=wucity;',2000);
 sql = 'SELECT download_mp3, artist, albumname, isrc, download_mp3lofi FROM `magnatune_song_info` where 1'; % 401 times not found
 [res,resformat] = adodb_query(db, sql);


% these are for keeping book of missing items
not_found = [];
isrc = cell(numel(db_MTTClip.annots_ids),1);
for i = 1:numel(db_MTTClip.annots_ids)
    % ---
    % identify the clip by url 
    % ---
    % convert search string 
    s = db_MTTClip.clip_info_proper{i,9};
    
    idx = strcellfind(res.download_mp3,s);
    if isempty(idx)
        idx = strcellfind(res.download_mp3lofi,s);
    end
    
    % we'll have to loosen the search
    if isempty(idx) | idx < 1
%         warning(sprintf('! %s, album %s, artist %s!',clip_info_proper{i,1},...
%             clip_info_proper{i,5},clip_info_proper{i,4}));
        
        % make note ...
        not_found = cat(1,not_found,[str2num(clip_info_proper{i,1}), 0]);
        
        not_found(end,2) = 1;
        % ---
        % ok, no problem, lets look for the album and artist!
        % ---
        s = char(clip_info_proper{i,5});
        idx = strcellfind(res.albumname,s);
    end


    if isempty(idx) | idx < 1
        warning(sprintf('-- Album not found %s, album %s, artist %s!',clip_info_proper{i,1},...
            clip_info_proper{i,5},clip_info_proper{i,4}));

        not_found(end,2) = 2;
        % ---
        % search for artist
        % ---
        s = char(clip_info_proper{i,4});
        idx = strcellfind(res.artist,s);
    end
        
    if  isempty(idx) | idx < 0
        warning(sprintf(' ---- Artist not found %s, album %s, artist %s!',clip_info_proper{i,1},...
            clip_info_proper{i,5},clip_info_proper{i,4}));
        not_found(end,2) = 3;
%             % ---
%             % this is the last try to get hold of such artists
%             % they may be noted as a trackname or description substring in a compilation
%             % ---
%             s = char(clip_info_proper{i,4});
%             idx = substrcellfind(tmp(:,2),s);
    else
        isrc{i} = char(res.isrc{idx});
    end
        
       
        % report new location/info of album
        
        % ---
        % save genre
        % ---
        %clip_info_extra = cat(1,clip_info_extra,{clip_info_proper{i,1},tmp{idx,rel_cols}});
        
end


