classdef MTTMixedFeatureStober11Slaney08GenreBasicSm < MTTAudioFeature & handle
    % ---
    %
    % The usual worklow for these features constist of three steps
    % 1. extract: extracts the basic single-file dependent features
    % 2. define_global_transform: calculates the global feature
    %       transformation parameters
    % 3. finalise: applies the common transformations to a specific feature
    % ---
    
    properties(Constant = true)
        
        % svn hook
        my_revision = str2double(substr('$Rev: 638 $',  5, -1));
    end
       
    properties
        % ---
        % Set default parameters
        % ---
        my_params = MTTAudioFeature.inherited_params(...
            'MTTMixedFeatureSlaney08GenreBasicSm', ...
            ... % ---
            ... % these are Stober11 parameters
            ... % ---
            'stob_lowaudio', 1, ...
            'stob_highaudio', 1, ... % 
            'stob_tags', 1, ... 
            'stob_norm', 1 ...
            ... % ---
        );
    end
    
    % ---
    % member functions
    % ---
    methods
        
        % ---
        % constructor: pointer to feature in database
        % ---
        function feature = MTTMixedFeatureStober11Slaney08GenreBasicSm(varargin)

            feature = feature@MTTAudioFeature(varargin{:});
        end

        % ---
        % extract feature data by combining genre adn stob features
        % ---
        function data = extract(feature, clip)
            
            % ---
            % get Basic Summary audio features. this includes possible
            % local normalisations
            % ---
            stob = clip.features('MTTMixedFeatureStober11',feature.my_params);
            
            % ---
            % get genre tag features
            % ---
            genrebasicsm = clip.features('MTTMixedFeatureSlaney08GenreBasicSm',feature.my_params);
            
            % save to features data field
            data.stob = stob;
            data.tags = genrebasicsm;
            
            % prepare field for final features
            data.final.vector = [];
            data.final.vector_info = struct(); 
            data.final.dim = 0;
           
            % save info data
            data.info.type = 'MTTMixedFeatureStober11Slaney08GenreBasicSm';
            data.info.owner_id = clip.id;
            data.info.creatorrev = feature.my_revision;
            
            % save parameters
            data.info.params = feature.my_params;
        end
        
        function define_global_transform(features)
        % calculate and set normalization factors from the group of 
        % input features. These features will be set for the full database
        
            if numel(features) == 1
                error ('Insert feature array for this method');
            end
            
            % ---
            % We collect all the relevant stob 
            % features and get the transform on this basis.
            % ---
            for i = 1:numel(features)
            	stob(i) = features(i).data.stob;
            end
            
            % call the features own transsform function
            stob.define_global_transform();
            
            % ---
            % We collect all the relevant genretag 
            % features and get the transform on this basis.
            % ---
            for i = 1:numel(features)
            	genrebasicsm(i) = features(i).data.tags;
            end
            
            % call the features own transsform function
            genrebasicsm.define_global_transform();
            
            % ---
            % set common feature values for mixed features
            % ---
            features(1).my_db.set_common([1]); %trivial common
        end
        
        
        function finalise(feature)
        % applies a final transformation and collects the 
        % information of this feature within a single vector
        % see info for types in specific dimensions

            for i = 1:numel(feature)
                
                % check for neccesary parameters
                if isempty(feature(i).my_db.commondb)

                    error('Define the global transformation first');
                end
                
                % ---
                % finalise audio feature and get vector
                % ---
                stob = feature(i).data.stob;
                stob.finalise();
                
                % finalise tag features
                genrebasicsm = feature(i).data.tags;
                genrebasicsm.finalise();
                
                % ---
                % final data assembly
                % ---
                
                % concatenate vectors
                feature(i).data.final.vector = ...
                    [stob.vector() ; genrebasicsm.vector()];
                
                % add feature dimensions
                feature(i).data.final.dim = stob.dim + genrebasicsm.dim;
                
                % concatenate labels
                feature(i).data.final.vector_info.labels = ...
                    {stob.data.final.vector_info.labels{:}, ...
                    genrebasicsm.data.final.vector_info.labels{:}};
            end
        end
        
        % ---
        % destructor: do we really want to remove this 
        % from the database? No, but 
        % TODO: create marker for unused objects in db, and a cleanup
        %  function
        % ---
        function delete(feature)
            
        end
       
        function visualise(feature)
        % ---
        % plots the different data types collected in this feature
        % ---
            for i = 1:numel(feature)
                clip = MTTClip(feature(i).owner_id());
            end
        end
    end
end