% ---
% This is the class for magnatagatune clips
% ---

classdef MTTClip < Clip
    
    % ---
    % here come the internal clip properties.
    % the database is stored as a global variable
    % ---
    
     % ---
        % simple constructor
        % ---
    methods
        function clip = MTTClip(varargin)
            clip = clip@Clip(varargin{:},'db_MTTClip');
        end
        
        function out = mp3file(this)
        % returns filename for given genre id

            out = this.my_db.clip_info_proper{this.my_dbpos,10};
        end
        
        
        function filename = mp3file_full(this)
        % returns mp3 filename for given clip id
            
            global globalvars;
            filename = strcat(globalvars.tstaudiopath,this.mp3file());
            filename = strrep(filename,'\',globalvars.systemslash);
            filename = strrep(filename,'/',globalvars.systemslash);
        end
        
        function filename = featurefile_full(this)
        % returns xml filename for given clip id
        
        % ---
        % NOTE: the xml files are supposed to be in the folder
        % "xml" as subfolder of the mp3 file path
        % ---
            global globalvars;
            filename = strcat(globalvars.tstaudiopath,'xml\',...
            this.mp3file,'.xml');

            filename = strrep(filename,'/',globalvars.systemslash);
            filename = strrep(filename,'\',globalvars.systemslash);
        end
        
        
        % caution. last.fm dbs take a clip
        function [out, score, annotids] = fmtags(this)
            
            [out, score, annotids] = this.my_db.fmtagdb.annots(this);
        end
        
        % caution. last.fm dbs take a clip
        % TODO: revert this to general annotdb for compability
        function [out, score] = fmtag_ids(this)
            
            [out, score] = this.my_db.fmtagdb.annotids_for_owner(this);
        end
        
        function [out, score] = genre_ids(this)
        % returns clip genre for given clip id 
            
            [out, score] = this(1).my_db.genredb.annotids_for_owner([this.id]);
        end
        
        function [out, score, annotids] = genres(this)
        % returns name strings for given genre position ids
 
            [out, score, annotids] = this(1).my_db.genredb.annots([this.id]);
        end  
        
        function print(this)
        % prints out the album info

            fprintf('clip %d: %s by %s,\n on %s \n',this.id, ...
                this.title(), this.artist(), this.album());

            v = strcat(this.genres(),', ');
            fprintf(' genres: %s\n', strcat(v{:}));

            v = strcat(this.tags(),', ');
            fprintf(' tags: %s\n', strcat(v{:}));
            
            v = strcat(this.fmtags(),', ');
            fprintf(' last.fm tags: %s\n', strcat(v{:}));

            % if nargout == 0
            %     fprintf(out)
            % end
        end
        
    end
end