% ---
% class ClipComparedGraph
% Directed graph representing comparative clip similarities.
%
% each node represents a clip
% an edge a -> b is present if clipas a and b cooccur 
% in a comparison triplet
% 
% ---

classdef ClipComparedGraph < Graph

% ---
%  the methods
% ---
methods

    
% constructor of the graph
function G = ClipComparedGraph(comparison, comparison_ids)
    
    if nargin == 2
    % ---
    % handle automatic or manual input
    % ---
    for i = 1:size(comparison,1)

        % get clips and votes
        clips = comparison_ids(comparison(i,1:3));
    
        % edges
        G.add_edge(clips(1), clips(2), 1);
        G.add_edge(clips(1), clips(3), 1);
        G.add_edge(clips(2), clips(3), 1);
%         
%         % symmectric edges
%         G.add_edge(clips(2), clips(1), 1);
%         G.add_edge(clips(3), clips(1), 1);
%         G.add_edge(clips(3), clips(2), 1);
    end
    
    elseif nargin == 1
        
        % ---
        % Add the input graph to the empty one
        % ---
        G.add_graph(comparison);
        
    end
    
% end constructor function
end

end
end


