function out = print_error(err)
% ---
% print error messages
% and following lines: stack
% ---
out.msg = sprintf('%s\n',err.message);
if nargout < 1 
    fprintf(out.msg);
end

for e = 1:length(err.stack)
  out.line{e} = sprintf('%s at %i\n',err.stack(e).name, err.stack(e).line);
  if nargout < 1 
      fprintf(out.line{e});
  end
end

