function r=vis_show_gui_tool(h,action,varargin)

%VIS_SHOW_GUI_TOOL is a subfunction of SOM_SHOW_GUI.
%
%  r = vis_show_gui_tool(handle, action, varargin)
%
%  Input arguments:
%     handle    (struct) 
%     action    (string)
%     varargin  (varies)
% 
% See also  SOM_SHOW_GUI.

% Copyright (c) 2000 by Roman Feldman and Juha Vesanto
% Contributed to SOM Toolbox on August 22nd, 2000
% http://www.cis.hut.fi/projects/somtoolbox/
 
% Version 2.0beta roman 160800 juuso 220800

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if ishandle(h(1)),
  udata = get(h(1),'UserData');
  if isfield(udata,'plot_array'),
    plot_array = udata.plot_array;
    if isfield(udata,'vis_h')
      % get most recent plotted
      children = get(0,'children');
      %  first refresh plot info
      udata.vis_h = setdiff(udata.vis_h,setdiff(udata.vis_h,children));
      set(h(1),'userdata',udata);
      for i=1:length(children),
        if any(children(i)==udata.vis_h),
          child = children(i);
          [handles,msg,lattice,msize,dim]=vis_som_show_data('all',children(i));
          break;
        elseif i==length(children),
          errordlg({'Plot not found', ...
                    'Try to visualize first'},'Error in SOM_VIS: tools');
          return;
        end
      end
    else
      errordlg({'Plot not found', ...
                'Try to visualize first'},'Error in SOM_VIS: tools');
      return;
    end
  end
end

%---  color vars  ---
  fig_color = [0.8 0.8 0.8];
  bg_color1 = [0.701960784313725 0.701960784313725 0.701960784313725];
  bg_color2 = [0.9 0.9 0.9];
%---  object position vars (in pixels) ---
  % calculations based on case 'comp'
  %% hint text
  hint_dist1 = 98.17-(61.27+36.9);   % hint text lower edge and next lower frame upper edge
  hint_dist2 = 123-(98.17+18.45);    % figure upper edge and hint text upper edge
  %% general
  dist1 = 67.42-61.27;               % general distance between frame edge and object in frame
  %% frame + ok / cancel
  frames_dist = 61.27-(8.38+36.9);
  frames_dist2 = 8.38;
  f_fr = [7.9 8.38 216.2 36.9];      % final frame
  ok_pb = [17.1 15.76 75.9 22.14];
  cancel_pb = [139 15.76 75.9 22.14];
  %% objects
  hint_txt = [460 18.45];           % hint text width and height
  interp_cb = [98.9 24.6];
  title_txt = [90 hint_txt(2)-3];
  title_edit_h =  23.083;
  var_pop = [interp_cb(1) ok_pb(4)];
  list_lt = [130 130];
  calc_txt = [list_lt(1) hint_txt(2)];
  selvar_pb = [110 ok_pb(4)];
  strd_ed = [var_pop(1) title_edit_h];
  radio_rb = selvar_pb;
  
 %%%%%%%%%%%
% add_label %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%
if strcmp(action,'add_label')
  old_fig_n = watchon;
  W = 345.4; H = 222.769;
  o21 = zeros(1,4);
  o21(1) = (W-f_fr(3))/2;
  f_fr = [7.9 8.38 (W-2*7.9) 36.9];      % final frame
  cancel_pb = [(W-(ok_pb(1)+75.9)) 15.76 75.9 22.14];
  hint_txt = [W 18.45];           % hint text width and height
  units = get(h,'units');
  set(h,'units','pixels');
  fp = get(h,'Position');
  fig_pos = [(fp(1)+fp(3)) ...
             (fp(2)+fp(2)+fp(4)/2-H/2) ...
             W ...
             H];
  o1 = sum(f_fr([2 4]))+frames_dist;
  o2 = 4*dist1+2*max([title_edit_h,title_txt(2)]) ...
      +max([title_txt(2),var_pop(2)]);
  o6 = max([title_txt(2),var_pop(2)]);
  o7 = max([title_txt(2),title_edit_h]);
  o8 = max([title_txt(2),title_edit_h,selvar_pb(2)]);
  o3 = o1+0.5*o6+dist1-title_txt(2)/2;
  o4 = o1+0.5*o6+dist1-var_pop(2)/2;  
  o5 = ok_pb(1)+title_txt(1);
  o9 = o1+o6+0.5*o7+2*dist1-title_txt(2)/2;
  o10 = o1+o6+0.5*o7+2*dist1-title_edit_h/2;;
  o11 = o1+o6+o7+0.5*o8+3*dist1-title_txt(2)/2;
  o12 = o1+o6+o7+0.5*o8+3*dist1-title_edit_h/2;
  o13 = o1+o6+o7+0.5*o8+3*dist1-selvar_pb(2)/2;
  o15 = o1+o2+frames_dist2;
  o16 = 2*dist1+o7;
  o17 = o5+strd_ed(1)+2*dist1; % W-ok_pb(1)-selvar_pb(1);
  o18 = o15+0.5*o7+dist1-title_txt(2)/2;
  o19 = o15+0.5*o7+dist1-title_edit_h/2;
  o20 = o15+o16+hint_dist1;
  hint_text_pos = [1 o20 hint_txt];
  frame1_pos = [f_fr(1) o15 f_fr(3) o16];
  subplots_text_pos = [ok_pb(1) o18 title_txt];
  subplots_pos = [o5 o19 strd_ed];
  frame2_pos = [f_fr(1) o1 f_fr(3) o2];
  labels_text_pos = [ok_pb(1) o11 title_txt];
  labels_pos = [o5 o12 strd_ed];
  sel_var_pos = [o17 o13 selvar_pb];
  text_size_text_pos = [ok_pb(1) o9 title_txt];
  text_size_pos = [o5 o10  strd_ed];
  text_color_text_pos = [ok_pb(1) o3 title_txt];
  text_color_pos = [o5 o4 var_pop];
  f_fr = [7.9 8.38 216.2 36.9];      % final frame
  cancel_pb = [139 15.76 75.9 22.14];
  frame3_pos = f_fr+o21;
  ok_pos = ok_pb+o21;
  cancel_pos = cancel_pb+o21;

  fig_h = figure( ...
    'Units','pixels', ...
    'Position', fig_pos, ...
    'Color',fig_color, ...
    'NumberTitle','off', ...
    'Name','add label', ...
    'MenuBar','none', ...
    'Visible','off');

    set( ...
    uicontrol( ...                                                            %% hint
      'Units','pixels', ...
      'BackgroundColor',fig_color, ...
      'HorizontalAlignment','center', ...
      'Position',hint_text_pos, ...
      'String','Options for adding labels', ...
      'Style','text'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame1_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% To subplot(s)
    'Units','pixels', ...
    'Position',subplots_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','To subplot(s)', ...
    'Style','text'),'units','normalized');

  ed1_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',subplots_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame2_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Labels
    'Units','pixels', ...
    'Position',labels_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Labels', ...
    'Style','text'),'units','normalized');

  ed2_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',labels_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed2_h,'units','normalized');

  s = ['tmp=get(' mat2str(fig_h) ',''userdata'');' ...
       'vis_show_gui_tool(tmp(2),''select'')'];
  set( ...
  uicontrol( ...                                                            %% Select variable
    'Units','pixels', ...
    'Position',sel_var_pos, ...
    'String','Select variable', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Text size
    'Units','pixels', ...
    'Position',text_size_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Text size', ...
    'Style','text'),'units','normalized');

  ed3_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',text_size_pos, ...
    'String','10', ...
    'FontSize',12, ...
    'Style','edit');
  set(ed3_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Text color
    'Units','pixels', ...
    'Position',text_color_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Text color', ...
    'Style','text'),'units','normalized');

  ud = {'k' 'w' 'y' 'm' 'c' 'r' 'g' 'b' 'xor' 'none'};
  s = {'black' 'white' 'yellow' 'magenta' 'cyan' 'red' 'green' ...
       'blue' 'xor' 'none'};
  p_h = uicontrol( ...                                                      %% [popupmenu]
    'Units','pixels', ...
    'Position',text_color_pos, ...
    'UserData',ud, ...
    'String',s, ...
    'Style','popupmenu');
  set(p_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame3_pos, ...
    'Style','frame'),'units','normalized');

  s = ['vis_show_gui_tool(' mat2str(h) ',''label'',' mat2str(fig_h) ')'];
  set( ...
  uicontrol( ...                                                            %% OK
    'Units','pixels', ...
    'Position',ok_pos, ...
    'String','OK', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Cancel
    'Units','pixels', ...
    'Position',cancel_pos, ...
    'String','Cancel', ...
    'Callback',['close(' mat2str(fig_h) ')']),'units','normalized');

  watchoff(old_fig_n);
  ud = [ed1_h ed2_h ed3_h p_h];
  set(fig_h,'units','normalized', ...
            'Visible','on', ...
            'UserData',ud, ...
            'handlevisibility','off');

 %%%%%%%%%
% add_hit %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%
elseif strcmp(action,'add_hit')
  old_fig_n = watchon;
  W = 424.3; H = 337.642;
  o37 = zeros(1,4);
  o37(1) = (W-f_fr(3))/2;
  f_fr = [7.9 8.38 (W-2*7.9) 36.9];      % final frame
  cancel_pb = [(W-(ok_pb(1)+75.9)) 15.76 75.9 22.14];
  hint_txt = [W 18.45];           % hint text width and height
  units = get(h,'units');
  set(h,'units','pixels');
  fp = get(h,'Position');
  fig_pos = [(fp(1)+fp(3)) ...
             (fp(2)+fp(2)+fp(4)/2-H/2) ...
             W ...
             H];
  o1 = sum(f_fr([2 4]))+frames_dist;
  o2 = o1+dist1;
  o6 = max([title_txt(2),var_pop(2)]);
  o7 = max([title_txt(2),title_edit_h]);
  o8 = max([title_txt(2),title_edit_h,var_pop(2)]);
  o38 = max([title_txt(2),title_edit_h,selvar_pb(2)]);
  o3 = o8+o6+3*dist1;
  o4 = o1+0.5*o8+dist1-title_txt(2)/2;
  o5 = o1+0.5*o8+dist1-var_pop(2)/2;
  o9 = o1+0.5*o8+dist1-title_edit_h/2;
  o21 = o1+o8+0.5*o6+2*dist1-title_txt(2)/2;
  o22 = o1+o8+0.5*o6+2*dist1-var_pop(2)/2;
  o20 = ok_pb(1)+title_txt(1);
  o10 = o20+var_pop(1)+2*dist1;
  o11 = o10+title_txt(1);
  o12 = o2+o8+dist1+0.5*o6-title_txt(2)/2;
  o13 = o2+o8+dist1+0.5*o6-var_pop(2)/2;
  o14 = o1+o3+frames_dist2;
  o15 = 2*o6+o8+4*dist1;
  o16 = o14+dist1+0.5*o6-title_txt(2)/2;
  o17 = o14+dist1+0.5*o6-var_pop(2)/2;
  o18 = o14+o6+2*dist1+0.5*o8-title_txt(2)/2;
  o19 = o14+o6+2*dist1+0.5*o8-title_edit_h/2;
  o23 = o14+o6+2*dist1+0.5*o8-var_pop(2)/2;
  o24 = o14+o6+3*dist1+o8+0.5*o6-title_txt(2)/2;
  o25 = o14+o6+3*dist1+o8+0.5*o6-var_pop(2)/2;
  o26 = o14+o15+frames_dist2;
  o27 = o8+2*dist1;
  o28 = o26+dist1+0.5*o38-title_txt(2)/2;
  o29 = o26+dist1+0.5*o38-title_edit_h/2;
  o30 = o26+dist1+0.5*o38-selvar_pb(2)/2;
  o31 = o10; %W-(ok_pb(1)+selvar_pb(1));
  o32 = o26+o27+frames_dist2;
  o33 = o7+2*dist1;
  o34 = o32+dist1+0.5*o7-title_txt(2)/2;
  o35 = o32+dist1+0.5*o7-title_edit_h/2;
  o36 = o32+o33+hint_dist1;
  hint_text_pos = [1 o36 hint_txt];
  frame1_pos = [f_fr(1) o32 f_fr(3) o33];
  subplots_text_pos = [ok_pb(1) o34 title_txt];
  subplots_pos = [o20 o35 strd_ed];
  frame2_pos = [f_fr(1) o26 f_fr(3) o27];
  trace_vect_text_pos = [ok_pb(1) o28 title_txt];
  trace_vect_pos = [o20 o29 strd_ed];
  sel_vect_pos = [o31 o30 selvar_pb];
  frame3_pos = [f_fr(1) o14 f_fr(3) o15];
  marker_text_pos = [ok_pb(1) o24 title_txt];
  marker_pos = [o20 o25 var_pop];
  marker_size_text_pos = [ok_pb(1) o18 title_txt];
  marker_size_pos = [o20 o19 strd_ed];
  size_fact_text_pos = [o10 o18 title_txt];
  size_fact_pos = [o11 o23 var_pop];
  marker_color_text_pos = [ok_pb(1) o16 title_txt];
  marker_color_pos = [o20 o17 var_pop];
  edge_color_text_pos = [o10 o16 title_txt];
  edge_color_pos = [o11 o17 var_pop];
  frame4_pos = [f_fr(1) o1 f_fr(3) o3];
  text_text_pos = [ok_pb(1) o21 title_txt];
  text_pos = [o20 o22 var_pop];
  text_color_text_pos = [ok_pb(1) o4 title_txt];
  text_color_pos = [o20 o5 var_pop];
  text_size_text_pos = [o10 o4 title_txt];
  text_size_pos = [o11 o9 strd_ed];
  f_fr = [7.9 8.38 216.2 36.9];      % final frame
  cancel_pb = [139 15.76 75.9 22.14];
  frame5_pos = f_fr+o37;
  ok_pos = ok_pb+o37;
  cancel_pos = cancel_pb+o37;

  fig_h = figure( ...
    'Units','pixels', ...
    'Position', fig_pos, ...
    'Color',fig_color, ...
    'NumberTitle','off', ...
    'Name','add hit histogram', ...
    'MenuBar','none', ...
    'Visible','off');

    set( ...
    uicontrol( ...                                                            %% hint
      'Units','pixels', ...
      'BackgroundColor',fig_color, ...
      'HorizontalAlignment','center', ...
      'Position',hint_text_pos, ...
      'String','Options for adding hit histogram', ...
      'Style','text'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame1_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% To subplot(s)
    'Units','pixels', ...
    'Position',subplots_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','To subplot(s)', ...
    'Style','text'),'units','normalized');

  ed1_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',subplots_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame2_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Trace vector
    'Units','pixels', ...
    'Position',trace_vect_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Hit vector', ...
    'Style','text'),'units','normalized');

  ed2_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',trace_vect_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed2_h,'units','normalized');

  s = ['tmp=get(' mat2str(fig_h) ',''userdata'');' ...
       'vis_show_gui_tool(tmp(2),''select'')'];
  set( ...
  uicontrol( ...                                                            %% Select variable
    'Units','pixels', ...
    'Position',sel_vect_pos, ...
    'String','Select variable', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame3_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Marker
    'Units','pixels', ...
    'Position',marker_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Marker', ...
    'Style','text'),'units','normalized');

  s = {'lattice' 'o' '.' 'x' '+' '*' 's' 'd' 'v' '^' ...
       '<' '>' 'p' 'h' 'none' 'cell array'};
  p3_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',marker_pos, ...
    'String',s, ...
    'Style','popupmenu');
  s = ['tmp=get(' mat2str(fig_h) ',''userdata'');' ...
       'vis_show_gui_tool([tmp(6),16],''popup_select'')'];
  set(p3_h,'units','normalized','Callback',s);

  set( ...
  uicontrol( ...                                                            %% Marker size
    'Units','pixels', ...
    'HorizontalAlignment','left', ...
    'Position',marker_size_text_pos, ...
    'String','Marker size', ...
    'Style','text'),'units','normalized');

  ed4_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',marker_size_pos, ...
    'String','12', ...
    'FontSize',12, ...
    'Style','edit');
  set(ed4_h,'units','normalized','Callback',s);

  set( ...
  uicontrol( ...                                                            %% Size factor
    'Units','pixels', ...
    'HorizontalAlignment','left', ...
    'Position',size_fact_text_pos, ...
    'String','Size factor', ...
    'Style','text'),'units','normalized');

  s = {'common' 'separate'};
  p4_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',size_fact_pos, ...
    'String',s, ...
    'Style','popupmenu');
  set(p4_h,'units','normalized');


  set( ...
  uicontrol( ...                                                            %% Marker color
    'Units','pixels', ...
    'HorizontalAlignment','left', ...
    'Position',marker_color_text_pos, ...
    'String','Marker color', ...
    'Style','text'),'units','normalized');

  ud = {'w' 'k' 'y' 'm' 'c' 'r' 'g' 'b' 'none' ''};
  s = {'white' 'black' 'yellow' 'magenta' 'cyan' ...
       'red' 'green' 'blue' 'none' '-matrix-'};
  p5_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',marker_color_pos, ...
    'UserData',ud, ...
    'String',s, ...
    'Style','popupmenu');
  s = ['tmp=get(' mat2str(fig_h) ',''userdata'');' ...
      'vis_show_gui_tool([tmp(9) 10],''popup_select'')'];
  set(p5_h,'units','normalized','Callback',s);

  set( ...
  uicontrol( ...                                                            %% EdgeColor
    'Units','pixels', ...
    'Position',edge_color_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Edge color', ...
    'Style','text'),'units','normalized');

  ud = {'none' 'w' 'k' 'y' 'm' 'c' 'r' 'g' 'b'};
  s = {'none' 'white' 'black' 'yellow' 'magenta' 'cyan' ...
       'red' 'green' 'blue'};
  p6_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',edge_color_pos, ...
    'UserData',ud, ...
    'String',s, ...
    'Style','popupmenu');
  set(p6_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame4_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Text
    'Units','pixels', ...
    'Position',text_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Text', ...
    'Style','text'),'units','normalized');

  s = {'off' 'on'};
  p2_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',text_pos, ...
    'String',s, ...
    'Style','popupmenu');
  set(p2_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Text
    'Units','pixels', ...
    'Position',text_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Text', ...
    'Style','text'),'units','normalized');

  s = {'off' 'on'};
  p2_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',text_pos, ...
    'String',s, ...
    'Style','popupmenu');
  set(p2_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Text color
    'Units','pixels', ...
    'Position',text_color_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Text color', ...
    'Style','text'),'units','normalized');

  ud = {'k' 'w' 'y' 'm' 'c' 'r' 'g' 'b' 'xor'};
  s = {'black' 'white' 'yellow' 'magenta' 'cyan' ...
       'red' 'green' 'blue' 'xor'};
  p1_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',text_color_pos, ...
    'UserData',ud, ...
    'String',s, ...
    'Style','popupmenu');
  set(p1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Text size
    'Units','pixels', ...
    'Position',text_size_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Text size', ...
    'Style','text'),'units','normalized');

  ed3_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',text_size_pos, ...
    'String','3', ...
    'FontSize',12, ...
    'Style','edit');
  set(ed3_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame5_pos, ...
    'Style','frame'),'units','normalized');

  s = ['vis_show_gui_tool(' mat2str(h) ',''hit'',' mat2str(fig_h) ')'];
  set( ...
  uicontrol( ...                                                            %% OK
    'Units','pixels', ...
    'Position',ok_pos, ...
    'String','OK', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Cancel
    'Units','pixels', ...
    'Position',cancel_pos, ...
    'String','Cancel', ...
    'Callback',['close(' mat2str(fig_h) ')']),'units','normalized');

  watchoff(old_fig_n);
  tmp_udata = [ed1_h ed2_h p1_h ed3_h p2_h p3_h ed4_h p4_h p5_h p6_h];
  set(fig_h,'units','normalized', ...
            'Visible','on', ...
            'UserData',tmp_udata, ...
            'handlevisibility','off');

 %%%%%%%%%%
% add_traj %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%
elseif strcmp(action,'add_traj')
  old_fig_n = watchon;
  W = 424.3; H = 337.642;
  o34 = zeros(1,4);
  o34(1) = (W-f_fr(3))/2;
  f_fr = [7.9 8.38 (W-2*7.9) 36.9];      % final frame
  cancel_pb = [(W-(ok_pb(1)+75.9)) 15.76 75.9 22.14];
  hint_txt = [W 18.45];           % hint text width and height
  units = get(h,'units');
  set(h,'units','pixels');
  fp = get(h,'Position');
  fig_pos = [(fp(1)+fp(3)) ...
             (fp(2)+fp(2)+fp(4)/2-H/2) ...
             W ...
             H];
  o1 = sum(f_fr([2 4]))+frames_dist;
  o2 = o1+dist1;
  o6 = max([title_txt(2),var_pop(2)]);
  o7 = max([title_txt(2),title_edit_h]);
  o8 = max([title_txt(2),title_edit_h,var_pop(2)]);
  o38 = max([title_txt(2),title_edit_h,selvar_pb(2)]);
  o20 = ok_pb(1)+title_txt(1);
  o10 = o20+var_pop(1)+2*dist1;
  o11 = o10+title_txt(1);
  o3 = 2*o6+o8+4*dist1;
  o4 = o1+dist1+0.5*o6-title_txt(2)/2;
  o5 = o1+dist1+0.5*o6-var_pop(2)/2;
  o9 = o1+2*dist1+o6+0.5*o8-title_txt(2)/2;
  o12 = o1+2*dist1+o6+0.5*o8-title_edit_h/2;
  o13 = o1+2*dist1+o6+0.5*o8-var_pop(2)/2;
  o14 = o1+3*dist1+o6+o8+0.5*o6-title_edit_h/2;
  o15 = o1+3*dist1+o6+o8+0.5*o6-var_pop(2)/2;
  o16 = o1+o3+frames_dist2;
  o17 = o8+o6+3*dist1;
  o18 = o16+dist1+0.5*o8-title_txt(2)/2;
  o19 = o16+dist1+0.5*o8-title_edit_h/2;
  o21 = o16+dist1+0.5*o8-var_pop(2)/2;
  o22 = o16+2*dist1+o8+0.5*o6-title_txt(2)/2;
  o23 = o16+2*dist1+o8+0.5*o6-var_pop(2)/2;
  o24 = o16+o17+frames_dist2;
  o25 = o38+2*dist1;
  o26 = o24+dist1+0.5*o38-title_txt(2)/2;
  o27 = o24+dist1+0.5*o38-title_edit_h/2;
  o28 = o24+dist1+0.5*o38-selvar_pb(2)/2;
  o29 = o24+o25+frames_dist2;
  o30 = o7+2*dist1;
  o31 = o29+dist1+0.5*o7-title_txt(2)/2;
  o32 = o29+dist1+0.5*o7-title_edit_h/2;
  o33 = o29+o30+hint_dist1;
  hint_text_pos = [1 o33 hint_txt];
  frame1_pos = [f_fr(1) o29 f_fr(3) o30];
  subplots_text_pos = [ok_pb(1) o31 title_txt];
  subplots_pos = [o20 o32 strd_ed];
  frame2_pos = [f_fr(1) o24 f_fr(3) o25];
  trace_vect_text_pos = [ok_pb(1) o26 title_txt];
  trace_vect_pos = [o20 o27 strd_ed];
  sel_vect_pos = [o10 o28 selvar_pb];
  frame3_pos = [f_fr(1) o16 f_fr(3) o17];
  line_color_text_pos = [ok_pb(1) o22 title_txt];
  line_color_pos = [o20 o23 var_pop];
  line_width_text_pos = [ok_pb(1) o18 title_txt];
  line_width_pos = [o20 o19 strd_ed];
  width_factor_text_pos = [o10 o18 title_txt];
  width_factor_pos = [o11 o19 var_pop];
  frame4_pos = [f_fr(1) o1 f_fr(3) o3];
  marker_text_pos = [ok_pb(1) o14 title_txt];
  marker_pos = [o20 o15 var_pop];
  marker_size_text_pos = [ok_pb(1) o9 title_txt];
  marker_size_pos = [o20 o12 strd_ed];
  size_factor_text_pos = [o10 o9 title_txt];
  size_factor_pos = [o11 o13 var_pop];
  marker_color_text_pos = [ok_pb(1) o4 title_txt];
  marker_color_pos = [o20 o5 var_pop];
  edge_color_text_pos = [o10 o4 title_txt];
  edge_color_pos = [o11 o5 var_pop];
  f_fr = [7.9 8.38 216.2 36.9];      % final frame
  cancel_pb = [139 15.76 75.9 22.14];
  frame5_pos = f_fr+o34;
  ok_pos = ok_pb+o34;
  cancel_pos = cancel_pb+o34;

  fig_h = figure( ...
    'Units','pixels', ...
    'Position', fig_pos, ...
    'Color',fig_color, ...
    'NumberTitle','off', ...
    'Name','add trajectory', ...
    'MenuBar','none', ...
    'Visible','off');

    set( ...
    uicontrol( ...                                                            %% hint
      'Units','pixels', ...
      'BackgroundColor',fig_color, ...
      'HorizontalAlignment','center', ...
      'Position',hint_text_pos, ...
      'String','Options for adding trajectory', ...
      'Style','text'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame1_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...
    'Units','pixels', ...                                                   %% To subplot(s)
    'Position',subplots_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','To subplot(s)', ...
    'Style','text'),'units','normalized');

  ed1_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',subplots_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame2_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Trace vector
    'Units','pixels', ...
    'Position',trace_vect_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Trajectory', ...
    'Style','text'),'units','normalized');

  ed2_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',trace_vect_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed2_h,'units','normalized');

  s = ['tmp=get(' mat2str(fig_h) ',''userdata'');' ...
       'vis_show_gui_tool(tmp(2),''select'')'];
  set( ...
  uicontrol( ...                                                            %% Select variable
    'Units','pixels', ...
    'Position',sel_vect_pos, ...
    'String','Select variable', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame3_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Line color
    'Units','pixels', ...
    'Position',line_color_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Line color', ...
    'Style','text'),'units','normalized');

  ud = {'w' 'k' 'y' 'm' 'c' 'r' 'g' 'b' 'xor'};
  s = {'white' 'black' 'yellow' 'magenta' 'cyan' ...
       'red' 'green' 'blue' 'xor'};
  p1_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',line_color_pos, ...
    'UserData',ud, ...
    'String',s, ...
    'Style','popupmenu');
  set(p1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Line width
    'Units','pixels', ...
    'Position',line_width_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Line width', ...
    'Style','text'),'units','normalized');

  ed3_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',line_width_pos, ...
    'String','3', ...
    'FontSize',12, ...
    'Style','edit');
  set(ed3_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Factor
    'Units','pixels', ...
    'Position',width_factor_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Factor', ...
    'Style','text'),'units','normalized');

  s = {'hit' 'equal'};
  p2_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',width_factor_pos, ...
    'String',s, ...
    'Style','popupmenu');
  set(p2_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame4_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Marker
    'Units','pixels', ...
    'Position',marker_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Marker', ...
    'Style','text'),'units','normalized');

  s = {'o' '.' 'x' '+' '*' 's' 'd' 'v' '^' ...
       '<' '>' 'p' 'h' 'none'};
  p3_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',marker_pos, ...
    'String',s, ...
    'Style','popupmenu');
  set(p3_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Marker size
    'Units','pixels', ...
    'HorizontalAlignment','left', ...
    'Position',marker_size_text_pos, ...
    'String','Marker size', ...
    'Style','text'),'units','normalized');

  ed4_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',marker_size_pos, ...
    'String','10', ...
    'FontSize',12, ...
    'Style','edit');
  set(ed4_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Factor
    'Units','pixels', ...
    'HorizontalAlignment','left', ...
    'Position',size_factor_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Factor', ...
    'Style','text'),'units','normalized');

  s = {'hit' 'equal'};
  p4_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',size_factor_pos, ...
    'String',s, ...
    'Style','popupmenu');
  set(p4_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Marker color
    'Units','pixels', ...
    'HorizontalAlignment','left', ...
    'Position',marker_color_text_pos, ...
    'String','Marker color', ...
    'Style','text'),'units','normalized');

  ud = {'w' 'k' 'y' 'm' 'c' 'r' 'g' 'b' 'none'};
  s = {'white' 'black' 'yellow' 'magenta' 'cyan' ...
       'red' 'green' 'blue' 'none'};
  p5_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',marker_color_pos, ...
    'UserData',ud, ...
    'String',s, ...
    'Style','popupmenu');
  set(p5_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Edge color
    'Units','pixels', ...
    'Position',edge_color_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Edge color', ...
    'Style','text'),'units','normalized');

  ud = {'none' 'w' 'k' 'y' 'm' 'c' 'r' 'g' 'b'};
  s = {'none' 'white' 'black' 'yellow' 'magenta' 'cyan' ...
       'red' 'green' 'blue'};
  p6_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',edge_color_pos, ...
    'UserData',ud, ...
    'String',s, ...
    'Style','popupmenu');
  set(p6_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame5_pos, ...
    'Style','frame'),'units','normalized');

  s = ['vis_show_gui_tool(' mat2str(h) ',''traj'',' mat2str(fig_h) ')'];
  set( ...
  uicontrol( ...                                                            %% OK
    'Units','pixels', ...
    'Position',ok_pos, ...
    'String','OK', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Cancel
    'Units','pixels', ...
    'Position',cancel_pos, ...
    'String','Cancel', ...
    'Callback',['close(' mat2str(fig_h) ')']),'units','normalized');

  watchoff(old_fig_n);
  tmp_udata = [ed1_h ed2_h p1_h ed3_h p2_h p3_h ed4_h p4_h p5_h p6_h];
  set(fig_h,'units','normalized', ...
            'Visible','on', ...
            'UserData',tmp_udata, ...
            'handlevisibility','off');

 %%%%%%%%%%%
% add_comet %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%
elseif strcmp(action,'add_comet')
  old_fig_n = watchon;
  W = 424.3; H = 265.589;
  o26 = zeros(1,4);
  o26(1) = (W-f_fr(3))/2;
  f_fr = [7.9 8.38 (W-2*7.9) 36.9];      % final frame
  cancel_pb = [(W-(ok_pb(1)+75.9)) 15.76 75.9 22.14];
  hint_txt = [W 18.45];           % hint text width and height
  units = get(h,'units');
  set(h,'units','pixels');
  fp = get(h,'Position');
  fig_pos = [(fp(1)+fp(3)) ...
             (fp(2)+fp(2)+fp(4)/2-H/2) ...
             W ...
             H];
  o1 = sum(f_fr([2 4]))+frames_dist;
  o2 = o1+dist1;
  o6 = max([title_txt(2),var_pop(2)]);
  o7 = max([title_txt(2),title_edit_h]);
  o8 = max([title_txt(2),title_edit_h,var_pop(2)]);
  o38 = max([title_txt(2),title_edit_h,selvar_pb(2)]);
  o20 = ok_pb(1)+title_txt(1);
  o10 = o20+var_pop(1)+2*dist1;
  o11 = o10+title_txt(1);
  o3 = 2*o6+o7+4*dist1;
  o4 = o1+dist1+0.5*o6-title_txt(2)/2;
  o5 = o1+dist1+0.5*o6-var_pop(2)/2;
  o9 = o1+2*dist1+o6+0.5*o7-title_txt(2)/2;
  o12 = o1+2*dist1+o6+0.5*o7-title_edit_h/2;
  o13 = o1+3*dist1+o7+1.5*o6-title_txt(2)/2;
  o14 = o1+3*dist1+o7+1.5*o6-var_pop(2)/2;
  o15 = o1+o3+frames_dist2;
  o16 = o38+2*dist1;
  o17 = o15+dist1+0.5*o38-title_txt(2)/2;
  o18 = o15+dist1+0.5*o38-title_edit_h/2;
  o19 = o15+dist1+0.5*o38-selvar_pb(2)/2;
  o21 = o15+o16+frames_dist2;
  o22 = o7+2*dist1;
  o23 = o21+dist1+0.5*o7-title_txt(2)/2;
  o24 = o21+dist1+0.5*o7-title_edit_h/2;
  o25 = o21+o22+hint_dist1;
  hint_text_pos = [1 o25 hint_txt];
  frame1_pos = [f_fr(1) o21 f_fr(3) o22];
  subplots_text_pos = [ok_pb(1) o23 title_txt];
  subplots_pos = [o20 o24 strd_ed];
  frame2_pos = [f_fr(1) o15 f_fr(3) o16];
  trace_vect_text_pos = [ok_pb(1) o17 title_txt];
  trace_vect_pos = [o20 o18 strd_ed];
  sel_var_pos = [o10 o19 selvar_pb];
  frame3_pos = [f_fr(1) o1 f_fr(3) o3];
  marker_text_pos = [ok_pb(1) o13 title_txt];
  marker_pos = [o20 o14 var_pop];
  marker_size_text_pos = [ok_pb(1) o9 title_txt];
  marker_size_pos = [o20 o12 var_pop];
  marker_color_text_pos = [ok_pb(1) o4 title_txt];
  marker_color_pos = [o20 o5 var_pop];
  edge_color_text_pos = [o10 o4 title_txt];
  edge_color_pos = [o11 o5 var_pop];
  f_fr = [7.9 8.38 216.2 36.9];      % final frame
  cancel_pb = [139 15.76 75.9 22.14];
  frame4_pos = f_fr+o26;
  ok_pos = ok_pb+o26;
  cancel_pos = cancel_pb+o26;

  fig_h = figure( ...
    'Units','pixels', ...
    'Position', fig_pos, ...
    'Color',fig_color, ...
    'NumberTitle','off', ...
    'Name','add comet', ...
    'MenuBar','none', ...
    'Visible','off');

    set( ...
    uicontrol( ...                                                            %% hint
      'Units','pixels', ...
      'BackgroundColor',fig_color, ...
      'HorizontalAlignment','center', ...
      'Position',hint_text_pos, ...
      'String','Options for adding comet', ...
      'Style','text'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame1_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% To subplot(s)
    'Units','pixels', ...
    'Position',subplots_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','To subplot(s)', ...
    'Style','text'),'units','normalized');

  ed1_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',subplots_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame2_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Trace vector
    'Units','pixels', ...
    'Position',trace_vect_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Trace vector', ...
    'Style','text'),'units','normalized');

  ed2_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',trace_vect_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed2_h,'units','normalized');

  s = ['tmp=get(' mat2str(fig_h) ',''userdata'');' ...
       'vis_show_gui_tool(tmp(2),''select'')'];
  set( ...
  uicontrol( ...                                                            %% Select variable
    'Units','pixels', ...
    'Position',sel_var_pos, ...
    'String','Select variable', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame3_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Marker
    'Units','pixels', ...
    'Position',marker_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Marker', ...
    'Style','text'),'units','normalized');

  s = {'o' '.' 'x' '+' '*' 's' 'd' 'v' '^' ...
       '<' '>' 'p' 'h' 'lattice' 'none'};
  p1_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',marker_pos, ...
    'String',s, ...
    'Style','popupmenu');
  set(p1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Marker size
    'Units','pixels', ...
    'HorizontalAlignment','left', ...
    'Position',marker_size_text_pos, ...
    'String','Marker size', ...
    'Style','text'),'units','normalized');

  ed3_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',marker_size_pos, ...
    'String','[20 4]', ...
    'FontSize',12, ...
    'Style','edit');
  set(ed3_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Marker color
    'Units','pixels', ...
    'HorizontalAlignment','left', ...
    'Position',marker_color_text_pos, ...
    'String','Marker color', ...
    'Style','text'),'units','normalized');

  ud = {'w' 'k' 'y' 'm' 'c' 'r' 'g' 'b' 'none' ''};
  s = {'white' 'black' 'yellow' 'magenta' 'cyan' ...
       'red' 'green' 'blue' 'none' '-matrix-'};
  p2_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',marker_color_pos, ...
    'UserData',ud, ...
    'String',s, ...
    'Style','popupmenu');
  s = ['tmp=get(' mat2str(fig_h) ',''userdata'');' ...
       'vis_show_gui_tool([tmp(5) 10],''popup_select'')'];
  set(p2_h,'units','normalized','Callback',s);

  set( ...
  uicontrol( ...                                                            %% Edge color
    'Units','pixels', ...
    'Position',edge_color_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Edge color', ...
    'Style','text'),'units','normalized');

  ud = {'none' 'w' 'k' 'y' 'm' 'c' 'r' 'g' 'b'};
  s = {'none' 'white' 'black' 'yellow' 'magenta' 'cyan' ...
       'red' 'green' 'blue'};
  p3_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',edge_color_pos, ...
    'UserData',ud, ...
    'String',s, ...
    'Style','popupmenu');
  set(p3_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame4_pos, ...
    'Style','frame'),'units','normalized');

  s = ['vis_show_gui_tool(' mat2str(h) ',''comet'',' mat2str(fig_h) ')'];
  set( ...
  uicontrol( ...                                                            %% OK
    'Units','pixels', ...
    'Position',ok_pos, ...
    'String','OK', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Cancel
    'Units','pixels', ...
    'Position',cancel_pos, ...
    'String','Cancel', ...
    'Callback',['close(' mat2str(fig_h) ')']),'units','normalized');

  watchoff(old_fig_n);
  tmp_udata = [ed1_h ed2_h p1_h ed3_h p2_h p3_h];
  set(fig_h,'units','normalized', ...
            'Visible','on', ...
            'UserData',tmp_udata, ...
            'handlevisibility','off');

 %%%%%%%%%%%%
% recolorbar %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%%
elseif strcmp(action,'recolorbar')
  old_fig_n = watchon;
  W = 345.4; H = 237.299;
  o25 = zeros(1,4);
  o25(1) = (W-f_fr(3))/2;
  f_fr = [7.9 8.38 (W-2*7.9) 36.9];      % final frame
  cancel_pb = [(W-(ok_pb(1)+75.9)) 15.76 75.9 22.14];
  hint_txt = [W 18.45];           % hint text width and height
  units = get(h,'units');
  set(h,'units','pixels');
  fp = get(h,'Position');
  fig_pos = [(fp(1)+fp(3)) ...
             (fp(2)+fp(2)+fp(4)/2-H/2) ...
             W ...
             H];
  o1 = sum(f_fr([2 4]))+frames_dist;
  o2 = o1+dist1;
  o6 = max([title_txt(2),var_pop(2)]);
  o7 = max([title_txt(2),title_edit_h]);
  o8 = max([title_txt(2),title_edit_h,selvar_pb(2)]);
  o20 = ok_pb(1)+title_txt(1);
  o10 = o20+var_pop(1)+2*dist1;
  o11 = o10+title_txt(1);
  o3 = o6+2*dist1;
  o4 = o1+dist1+0.5*o6-title_txt(2)/2;
  o5 = o1+dist1+0.5*o6-var_pop(2)/2;
  o9 = o1+o3+frames_dist2;
  o12 = 2*o8+3*dist1;
  o13 = o9+dist1+0.5*o8-title_txt(2)/2;
  o14 = o9+dist1+0.5*o8-title_edit_h/2;
  o15 = o9+dist1+0.5*o8-var_pop(2)/2;
  o16 = o9+2*dist1+1.5*o8-title_txt(2)/2;
  o17 = o9+2*dist1+1.5*o8-title_edit_h/2;
  o18 = o9+2*dist1+1.5*o8-var_pop(2)/2;
  o19 = o9+o12+frames_dist2;
  o21 = o7+2*dist1;
  o22 = o19+dist1+0.5*o7-title_txt(2)/2;
  o23 = o19+dist1+0.5*o7-title_edit_h/2;
  o24 = o19+o21+hint_dist1;
  hint_text_pos = [1 o24 hint_txt];
  frame1_pos = [f_fr(1) o19 f_fr(3) o21];
  subplots_text_pos = [ok_pb(1) o22 title_txt];
  subplots_pos = [o20 o23 strd_ed];
  frame2_pos = [f_fr(1) o9 f_fr(3) o12];
  tics_text_pos = [ok_pb(1) o16 title_txt];
  tics_pos = [o20 o17 strd_ed];
  sel_var2_pos = [o10 o18 var_pop];
  labels_text_pos = [ok_pb(1) o13 title_txt];
  labels_pos = [o20 o14 strd_ed];
  sel_var1_pos = [o10 o15 var_pop];
  frame3_pos = [f_fr(1) o1 f_fr(3) o3];
  scale_text_pos = [ok_pb(1) o4 title_txt];
  scale_pos = [o20 o5 1.3*var_pop(1) var_pop(2)];
  f_fr = [7.9 8.38 216.2 36.9];      % final frame
  cancel_pb = [139 15.76 75.9 22.14];
  frame4_pos = f_fr+o25;
  ok_pos = ok_pb+o25;
  cancel_pos = cancel_pb+o25;

  fig_h = figure( ...
    'Units','pixels', ...
    'Position', fig_pos, ...
    'Color',fig_color, ...
    'NumberTitle','off', ...
    'Name','recolorbar', ...
    'MenuBar','none', ...
    'Visible','off');

    set( ...
    uicontrol( ...                                                            %% hint
      'Units','pixels', ...
      'BackgroundColor',fig_color, ...
      'HorizontalAlignment','center', ...
      'Position',hint_text_pos, ...
      'String','Options, recolorbar', ...
      'Style','text'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame1_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% In subplot(s)
    'Units','pixels', ...
    'Position',subplots_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','In subplot(s)', ...
    'Style','text'),'units','normalized');

  ed1_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',subplots_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame2_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Ticks
    'Units','pixels', ...
    'Position',tics_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Ticks', ...
    'Style','text'),'units','normalized');

  ed3_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',tics_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed3_h,'units','normalized');

  s = ['tmp=get(' mat2str(fig_h) ',''userdata'');' ...
       'vis_show_gui_tool(tmp(3),''select'')'];
  set( ...
  uicontrol( ...                                                            %% Select variable
    'Units','pixels', ...
    'Position',sel_var2_pos, ...
    'String','Select variable', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Labels (cell array)
    'Units','pixels', ...
    'Position',labels_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Labels', ...
    'Style','text'),'units','normalized');

  ed2_h = uicontrol( ...                                                    %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',labels_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed2_h,'units','normalized');

  s = ['tmp=get(' mat2str(fig_h) ',''userdata'');' ...
       'vis_show_gui_tool(tmp(2),''select'')'];
  set( ...
  uicontrol( ...                                                            %% Select variable
    'Units','pixels', ...
    'Position',sel_var1_pos, ...
    'String','Select variable', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame3_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Scale
    'Units','pixels', ...
    'Position',scale_text_pos, ...
    'HorizontalAlignment','left', ...
    'String','Scale', ...
    'Style','text'),'units','normalized');

  s = {'denormalized' 'normalized'};
  p1_h = uicontrol( ...                                                     %% [popupmenu]
    'Units','pixels', ...
    'Position',scale_pos, ...
    'String',s, ...
    'Style','popupmenu');
  set(p1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame4_pos, ...
    'Style','frame'),'units','normalized');

  s = ['vis_show_gui_tool(' mat2str(h) ',''do_recolorbar'',' mat2str(fig_h) ')'];
  set( ...
  uicontrol( ...                                                            %% OK
    'Units','pixels', ...
    'Position',ok_pos, ...
    'String','OK', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% Cancel
    'Units','pixels', ...
    'Position',cancel_pos, ...
    'String','Cancel', ...
    'Callback',['close(' mat2str(fig_h) ')']),'units','normalized');

  watchoff(old_fig_n);
  tmp_udata = [ed1_h ed2_h ed3_h p1_h];
  set(fig_h,'units','normalized', ...
            'Visible','on', ...
            'UserData',tmp_udata, ...
            'handlevisibility','off');

 %%%%%%%
% clear %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%
elseif strcmp(action,'clear')
  old_fig_n = watchon;
  W = 232; H = 277.463;
  o25 = zeros(1,4);
  o25(1) = (W-f_fr(3))/2;
  f_fr = [7.9 8.38 (W-2*7.9) 36.9];      % final frame
  cancel_pb = [(W-(ok_pb(1)+75.9)) 15.76 75.9 22.14];
  hint_txt = [W 18.45];           % hint text width and height
  units = get(h,'units');
  set(h,'units','pixels');
  fp = get(h,'Position');
  fig_pos = [(fp(1)+fp(3)) ...
             (fp(2)+fp(2)+fp(4)/2-H/2) ...
             W ...
             H];
  o1 = sum(f_fr([2 4]))+frames_dist;
  o2 = o1+dist1;
  o3 = (W-radio_rb(1))/2;
  o4 = o2+radio_rb(2)+dist1;
  o5 = o4+radio_rb(2)+dist1;
  o6 = o5+radio_rb(2)+dist1;
  o7 = o6+radio_rb(2)+dist1;
  o8 = 5*radio_rb(2)+6*dist1;
  o9 = o1+o8+frames_dist2;
  o10 = max([title_txt(2),title_edit_h]);
  o11 = o9+dist1+0.5*o10-title_txt(2)/2;
  o12 = o9+dist1+0.5*o10-strd_ed(2)/2;
  o20 = W-(ok_pb(1)+strd_ed(1));
  o13 = o10+2*dist1;
  o24 = o9+o13+hint_dist1;
  hint_text_pos = [1 o24 hint_txt];
  frame1_pos = [f_fr(1) o9 f_fr(3) o13];
  subplots_text_pos = [ok_pb(1) o11 title_txt];
  subplots_pos = [o20 o12 strd_ed];
  frame2_pos = [f_fr(1) o1 f_fr(3) o8];
  radiob1_pos = [o3 o7 selvar_pb];
  radiob2_pos = [o3 o6 selvar_pb];
  radiob3_pos = [o3 o5 selvar_pb];
  radiob4_pos = [o3 o4 selvar_pb];
  radiob5_pos = [o3 o2 selvar_pb];
  f_fr = [7.9 8.38 216.2 36.9];      % final frame
  cancel_pb = [139 15.76 75.9 22.14];
  frame3_pos = f_fr;%+o25;
  ok_pos = ok_pb;%+o25;
  cancel_pos = cancel_pb;%+o25;

  fig_h = figure( ...
    'Units','pixels', ...
    'Position', fig_pos, ...
    'Color',fig_color, ...
    'NumberTitle','off', ...
    'Name','clear label', ...
    'MenuBar','none', ...
    'Visible','off');

    set( ...
    uicontrol( ...                                                            %% hint
      'Units','pixels', ...
      'BackgroundColor',fig_color, ...
      'HorizontalAlignment','center', ...
      'Position',hint_text_pos, ...
      'String','Options for clearing', ...
      'Style','text'),'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame1_pos, ...
    'Style','frame'),'units','normalized');

  set( ...
  uicontrol( ...                                                               %% From subplots
    'Units','pixels', ...
    'Position',subplots_text_pos, ...
    'String','From subplots', ...
    'Style','text'),'units','normalized');

  ed1_h = uicontrol( ...                                                       %% [edit]
    'Units','pixels', ...
    'BackgroundColor',bg_color2, ...
    'Position',subplots_pos, ...
    'FontSize',12, ...
    'Style','edit');
  set(ed1_h,'units','normalized');

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame2_pos, ...
    'Style','frame'),'units','normalized');

  rb1_h = uicontrol( ...                                                       %% 
    'Units','pixels', ...
    'Position',radiob1_pos, ...
    'style','radiobutton', ...
    'String','All', ...
    'value',1);                

  rb2_h = uicontrol( ...                                                       %% 
    'Units','pixels', ...
    'Position',radiob2_pos, ...
    'style','radiobutton', ...
    'String','Comet');                

  rb3_h = uicontrol( ...                                                       %% 
    'Units','pixels', ...
    'Position',radiob3_pos, ...
    'style','radiobutton', ...
    'String','Hit');                

  rb4_h = uicontrol( ...                                                       %% 
    'Units','pixels', ...
    'Position',radiob4_pos, ...
    'style','radiobutton', ...
    'String','Label');                

  rb5_h = uicontrol( ...                                                       %% 
    'Units','pixels', ...
    'Position',radiob5_pos, ...
    'style','radiobutton', ...
    'String','Trajectory');                

  set( ...
  uicontrol( ...                                                            %% [frame]
    'Units','pixels', ...
    'Position',frame3_pos, ...
    'Style','frame'),'units','normalized');

  s = ['vis_show_gui_tool(' mat2str(h) ',''c_clear'',' mat2str(fig_h) ')'];
  set( ...
  uicontrol( ...                                                               %% OK
    'Units','pixels', ...
    'Position',ok_pos, ...
    'String','OK', ...
    'Callback',s),'units','normalized');

  set( ...
  uicontrol( ...                                                               %% Cancel
    'Units','pixels', ...
    'Position',cancel_pos, ...
    'String','Cancel', ...
    'Callback',['close(' mat2str(fig_h) ')']),'units','normalized');

  watchoff(old_fig_n);
  tmp_udata = [ed1_h rb1_h rb2_h rb3_h rb4_h rb5_h];
  set(fig_h,'units','normalized', ...
            'Visible','on', ...
            'UserData',tmp_udata, ...
            'handlevisibility','off');

 %%%%%%%%%
% c_clear %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%
elseif strcmp(action,'c_clear')
  thisfig = varargin{1};
  u = get(varargin{1},'UserData');
  s = get(u(1),'String');
  if ~isempty(s)
    if s(1)=='[' | (s(1)>='1' & s(1)<='9') 
      sprintf(s,'[%s]',s);
      e = eval(s); else e = s;
    end
    if vis_valuetype(e,{'1xn','nx1','string'}), 
      if ischar(e),
        if ~strcmp(e,'all'),
          errordlg({'Only valid string value' ...
                    'for subplot indices is ''all''.'}, ...
                    'Error in SOM_VIS: tools');
          return;
        else
          e=1:length(handles);
        end
      elseif any(e<1) | any(e>length(handles)),
        errordlg({'Subplot indices must be in', ...
               'range 1...number_of_subplots!'}, ...
              'Error in SOM_VIS: tools');
        return;
      end
    elseif ~isempty(e)
      errordlg('Invalid subplot indices!','Error in SOM_VIS: tools');
      return;
    end
  else,
    e = '';
  end
  set(0,'currentfigure',child)
  v = get(u(2),'value');
  if v,
    if ~isempty(e),
      som_show_clear('lab',e);
      som_show_clear('hit',e);
      som_show_clear('traj',e);
      som_show_clear('comet',e);
    else
      som_show_clear('lab');
      som_show_clear('hit');
      som_show_clear('traj');
      som_show_clear('comet');
    end
  end
  v = get(u(3),'value');
  if v,
    if ~isempty(e)
      som_show_clear('comet',e);
    else
      som_show_clear('comet');
    end
  end
  v = get(u(4),'value');
  if v,
    if ~isempty(e),
      som_show_clear('hit',e);
    else
      som_show_clear('hit');
    end
  end
  v = get(u(5),'value');
  if v,
    if ~isempty(e),
      som_show_clear('lab',e);
    else
      som_show_clear('lab');
    end
  end
  v = get(u(6),'value');
  if v,
    if ~isempty(e),
      som_show_clear('traj',e);
    else
      som_show_clear('traj');
    end
  end
  close(thisfig);

 %%%%%%%%%%%%%%
% do_recolorbar %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%%%%
elseif strcmp(action,'do_recolorbar')
  args = {};
  ud = get(varargin{1},'UserData');
  s = get(ud(1),'String');
  e = 1:length(handles);
  if ~isempty(s)
    if s(1)=='[' | (s(1)>='1' & s(1)<='9') 
      sprintf(s,'[%s]',s);
      e = eval(s); else e = s;
    end
    if vis_valuetype(e,{'1xn','nx1','string'}), 
      if ischar(e) & ~strcmp(e,'all'),
        errordlg({'Only valid string value' ...
                  'for subplot indices is ''all''.'}, ...
                  'Error in SOM_VIS: tools');
        return;
      elseif any(e<1) | any(e>length(handles)),
        errordlg({'Subplot indices must be in', ...
               'range 1...number_of_subplots.'}, ...
              'Error in SOM_VIS: tools');
        return;
      end
    elseif ~isempty(e)
      errordlg('Invalid subplot indices!','Error in SOM_VIS: tools');
      return;
    end
  end
  args = [args {e}];
  s = get(ud(3),'String');
  tmp = 'auto';
  if strcmp(s,'auto') | strcmp(s,'border'),
    tmp = s;
  elseif ~isempty(s)
    tmp = evalin('base',s);
  end
  args = [args {tmp}];
  v = get(ud(4),'Value');
  s = get(ud(4),'String');
  args = [args {s{v}}];
  s = get(ud(2),'String');
  if ~isempty(s)
    args = [args {evalin('base',s)}];
  end
  thisfig = varargin{1};
  % set(0,'CurrentFigure',udata.vis_h);
  set(0,'currentfigure',child)
  som_recolorbar(args{:});
  close(thisfig);

 %%%%%%%
% label %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%
elseif strcmp(action,'label')
  args = {'label'};
  ud = get(varargin{1},'UserData');
  s = get(ud(2),'String');
  if ~isempty(s)
    args = [args {evalin('base',s)}];
  else
    args = [args {udata.sM}];
  end
  s = get(ud(3),'String');
  if ~isempty(s)
    args = [args {'TextSize' eval(s)}];
  end
  v = get(ud(4),'Value');
  if v>1,
    s = get(ud(4),'UserData');
    args = [args {'TextColor' s{v}}];
  end
  s = get(ud(1),'String');
  if ~isempty(s)
    if s(1)=='[' | (s(1)>='1' & s(1)<='9') 
      sprintf(s,'[%s]',s);
      e = eval(s); else e = s; 
    end
    if vis_valuetype(e,{'1xn','nx1','string'}), 
      if ischar(e),
        if ~strcmp(e,'all'),
          errordlg({'Only valid string value' ...
                    'for subplot indices is ''all''.'}, ...
                   'Error in SOM_VIS: tools');
          return;
        else
          e=1:length(handles);
        end
      elseif any(e<1) | any(e>length(handles)),
        errordlg({'Subplot indices must be in', ...
               'range 1...number_of_subplots!'}, ...
              'Error in SOM_VIS: tools');
        return;
      end
    elseif ~isempty(e)
      errordlg('Invalid subplot indices!','Error in SOM_VIS: tools');
      return;
    end
    args = [args {'SubPlot' e}];
  end
  thisfig = varargin{1};
  % set(0,'CurrentFigure',udata.vis_h);
  set(0,'currentfigure',child)
  som_show_add(args{:});
  close(thisfig);

 %%%%%
% hit %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%
elseif strcmp(action,'hit')
  args = {'hit'};
  ud = get(varargin{1},'UserData');
  s = get(ud(2),'String');
  e = evalin('base',s);
  [dummy k] = size(e);
  args = [args {e}];
  v = get(ud(10),'Value');
  s = get(ud(10),'UserData');
  args = [args {'EdgeColor' s{v}}];
  %
  s = get(ud(7),'String');
  if ~isempty(s)
    args = [args {'MarkerSize' eval(s)}];
  end
  if k == 1,
    v = get(ud(6),'Value');
    if v<16,
      s = get(ud(6),'String');
      args = [args {'Marker' s{v}}];
    else
      % errordlg();
      return;
    end
    v = get(ud(9),'Value');
    if v<10,
      s = get(ud(9),'UserData');
      args = [args {'MarkerColor' s{v}}];
    else
      % errordlg();
      return;
    end
    %
    v = get(ud(5),'Value');
    s = get(ud(5),'String');
    args = [args {'Text' s{v}}];
    if v>1,  % 1='off'
      v = get(ud(3),'Value');
      s = get(ud(3),'UserData');
      args = [args {'TextColor' s{v}}];
      %
      s = get(ud(4),'String');
      args = [args {'TextSize' eval(s)}];
    end
  else
    v = get(ud(8),'Value');
    s = get(ud(8),'String');
    args = [args {'SizeFactor' s{v}}];
    %
    v = get(ud(6),'Value');
    s = get(ud(6),'String');
    args = [args {'Marker' s{v}}];
    %
    v = get(ud(9),'Value');
    s = get(ud(9),'UserData');
    args = [args {'MarkerColor' s{v}}];
  end

  s = get(ud(1),'String');
  if ~isempty(s)
    if s(1)=='[' | (s(1)>='1' & s(1)<='9') 
      sprintf(s,'[%s]',s);
      e = eval(s); else e = s; 
    end
    if vis_valuetype(e,{'1xn','nx1','string'}), 
      if ischar(e),
        if ~strcmp(e,'all'),
          errordlg({'Only valid string value' ...
                    'for subplot indices is ''all''.'}, ...
                   'Error in SOM_VIS: tools');
          return;
        else
          e=1:length(handles);
        end
      elseif any(e<1) | any(e>length(handles)),
        errordlg({'Subplot indices must be in', ...
               'range 1...number_of_subplots!'}, ...
              'Error in SOM_VIS: tools');
        return;
      end
    elseif ~isempty(e)
      errordlg('Invalid subplot indices!','Error in SOM_VIS: tools');
      return;
    end
    args = [args {'SubPlot' e}];
  end
  thisfig = varargin{1};
  % set(0,'CurrentFigure',udata.vis_h);
  set(0,'currentfigure',child)
  som_show_add(args{:});
  close(thisfig);

 %%%%%%
% traj %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%
elseif strcmp(action,'traj')
  args = {'traj'};
  ud = get(varargin{1},'UserData');
  s = get(ud(2),'String');
  args = [args {evalin('base',s)}];
  s = get(ud(4),'String');
  if ~isempty(s)
    args = [args {'TrajWidth' eval(s)}];
  end
  v = get(ud(5),'Value');
  if v>1,
    s = get(ud(5),'String');
    args = [args {'WidthFactor' s{v}}];
  end
  v = get(ud(3),'Value');
  if v>1,
    s = get(ud(3),'UserData');
    args = [args {'TrajColor' s{v}}];
  end
  v = get(ud(6),'Value');
  if v>1,
    s = get(ud(6),'String');
    args = [args {'Marker' s{v}}];
  end
  s = get(ud(7),'String');
  if ~isempty(s)
    args = [args {'MarkerSize' eval(s)}];
  end
  v = get(ud(8),'Value');
  if v>1,
    s = get(ud(8),'String');
    args = [args {'SizeFactor' s{v}}];
  end
  v = get(ud(9),'Value');
  if v>1,
    s = get(ud(9),'UserData');
    args = [args {'MarkerColor' s{v}}];
  end
  v = get(ud(10),'Value');
  if v>1,
    s = get(ud(10),'UserData');
    args = [args {'EdgeColor' s{v}}];
  end
  s = get(ud(1),'String');
  if ~isempty(s)
    if s(1)=='[' | (s(1)>='1' & s(1)<='9') 
      sprintf(s,'[%s]',s);
      e = eval(s); else e = s; 
    end
    if vis_valuetype(e,{'1xn','nx1','string'}), 
      if ischar(e),
        if ~strcmp(e,'all'),
          errordlg({'Only valid string value' ...
                    'for subplot indices is ''all''.'}, ...
                   'Error in SOM_VIS: tools');
          return;
        else
          e=1:length(handles);
        end
      elseif any(e<1) | any(e>length(handles)),
        errordlg({'Subplot indices must be in', ...
               'range 1...number_of_subplots!'}, ...
              'Error in SOM_VIS: tools');
        return;
      end
    elseif ~isempty(e)
      errordlg('Invalid subplot indices!','Error in SOM_VIS: tools');
      return;
    end
    args = [args {'SubPlot' e}];
  end
  thisfig = varargin{1};
  % set(0,'CurrentFigure',udata.vis_h);
  set(0,'currentfigure',child)
  som_show_add(args{:});
  close(thisfig);

 %%%%%%%
% comet %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%
elseif strcmp(action,'comet')
  args = {'comet'};
  ud = get(varargin{1},'UserData');
  s = get(ud(2),'String');
  args = [args {evalin('base',s)}];
  v = get(ud(3),'Value');
  if v>1,
    s = get(ud(3),'String');
    args = [args {'Marker' s{v}}];
  end
  s = get(ud(4),'String');
  if ~isempty(s)
    args = [args {'MarkerSize' eval(s)}];
  end
  v = get(ud(5),'Value');
  s = get(ud(5),'UserData');
  if v==10,
    args = [args {'MarkerColor' evalin('base',s{10})}];
  else
    args = [args {'MarkerColor' s{v}}];
  end
  v = get(ud(6),'Value');
  if v>1,
    s = get(ud(6),'UserData');
    args = [args {'EdgeColor' s{v}}];
  end
  s = get(ud(1),'String');
  if ~isempty(s)
    if s(1)=='[' | (s(1)>='1' & s(1)<='9') 
      sprintf(s,'[%s]',s);
      e = eval(s); else e = s; 
    end
    if vis_valuetype(e,{'1xn','nx1','string'}), 
      if ischar(e),
        if ~strcmp(e,'all'),
          errordlg({'Only valid string value' ...
                    'for subplot indices is ''all''.'}, ...
                   'Error in SOM_VIS: tools');
          return;
        else
          e=1:length(handles);
        end
      elseif any(e<1) | any(e>length(handles)),
        errordlg({'Subplot indices must be in', ...
               'range 1...number_of_subplots!'}, ...
              'Error in SOM_VIS: tools');
        return;
      end
    elseif ~isempty(e)
      errordlg('Invalid subplot indices!','Error in SOM_VIS: tools');
      return;
    end
    args = [args {'SubPlot' e}];
  end
  thisfig = varargin{1};
  % set(0,'CurrentFigure',udata.vis_h);
  set(0,'currentfigure',child)
  som_show_add(args{:});
  close(thisfig);

 %%%%%%%%
% select %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%
elseif strcmp(action,'select')
  %% NOTE: input h is not main_gui_handle
  %%       but edit menu handle
  w = evalin('base','whos');
  for (i=1:length(w)) 
    size_frst{i} = mat2str(w(i).size(1));
    x(i,1) = 'x';
    size_scnd{i} = mat2str(w(i).size(2));
  end    
  names = strvcat(w.name);
  [dummy vert] = size(names);
  for (i=1:length(w))
    for (j=1:8)
      sp(i,j) = ' ';
    end
  end
  size_M = strjust(strvcat(size_frst{:}),'right');
  size_N = strjust(strvcat(size_scnd{:}),'left');
  classes = strvcat(w.class);
  s = [cellstr([names sp size_M x size_N sp classes])]';

  [sel,ok] = listdlg('ListString',s,...
                     'Name','Variable selection',...
                     'PromptString','Select variable', ...
                     'SelectionMode','single');
  if ok & ~isempty(sel), 
    w = {w.name};
    if ishandle(h),
      set(h,'String',w{sel});
    elseif nargout==1,
      r = w{sel};
    end
  elseif nargout==1,
    r = '';
  end

 %%%%%%%%%%%%%%
% popup_select %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%%%%
elseif strcmp(action,'popup_select')
  %% NOTE: input h is not main_gui_handle
  %%       but h(1) is popupmenu handle and h(2:end) are indeces
  v = get(h(1),'Value');
  if any(v==h(2:end)),
    w = evalin('base','whos');
    for (i=1:length(w)) 
      size_frst{i} = mat2str(w(i).size(1));
      x(i,1) = 'x';
      size_scnd{i} = mat2str(w(i).size(2));
    end
    names = strvcat(w.name);
    [dummy vert] = size(names);
    for (i=1:length(w))
      for (j=1:8)
        sp(i,j) = ' ';
      end
    end
    size_M = strjust(strvcat(size_frst{:}),'right');
    size_N = strjust(strvcat(size_scnd{:}),'left');
    classes = strvcat(w.class);
    s = [cellstr([names sp size_M x size_N sp classes])]';
    [sel,ok] = listdlg('ListString',s,...
                       'Name','Variable selection',...
                       'PromptString','Select variable', ...
                       'SelectionMode','single');
    if ok & ~isempty(sel),
      w = {w.name};
      i = find(v==h(2:end));
      s = get(h(1),'String');
      s{h(i+1)} = w{sel};
      set(h(1),'String',s);
      if nargout==1,
        r = w{sel};
      end
    elseif nargout==1,
      r = '';
    end    
  end

end

