function [h,out] = dataspecgram(wavin, varargin)
%[h,spec] = dataspecgram(data,'sr',fs,'fftlen',2048,'stepw',1024,'winsize',2048,'min_fkhz',0.5,'max_fkhz',15,'nolog',0,'clip',0,'logadd',0);


[sr,fftlen, stepw,winsize,min_fkhz,max_fkhz,nolog,clip,logadd,fontsize,cutoff,colormode,unused]=process_options(varargin,...
    'sr',44800,'fftlen',2048,'stepw',1024,'winsize',2048,'min_fkhz',0.5,'max_fkhz',15,...
    'nolog',0,'clip',0,'logadd',0,'fontsize',8,'cutoff',0,'colormode','jet');
out= specgram(wavin,fftlen,sr,winsize,winsize-stepw);

wavlens=round(length(wavin)/sr*100)/100;

firstindex= max(round(fftlen/(sr)*min_fkhz*1000),1);
lastindex= min(round(fftlen/(sr)*max_fkhz*1000),fftlen/2);

out=out(firstindex:lastindex,:);
if nolog
    out=abs(out);
    out=sqrt(abs(out));
    out=out./max(max(out));
else
    out=log(0.000000001+logadd+abs(out));
    out=out./max(max(abs(out)));
    out=out+1;
end

%cut off small values
if cutoff
    for i=1:size(out,2)
        out((out(:,i)<cutoff),i)=0;
    end
end



if clip > 0
    h=image([0 wavlens],[min_fkhz max_fkhz],out*100*clip);
else
    h=imagesc([0 wavlens],[min_fkhz max_fkhz],out);
end

switch colormode
    case 'inv'
        color= 'w';
        bgcolor= 'k';
        colormap(hot);
    case 'bw'
        color= 'black';
        colormap(1-grey);
        bgcolor= 'w';
    case 'jet'
        color= 'black';
        colormap(jet);
        bgcolor= 'w';
end

set(gca,'FontSize',fontsize,'xcolor',color);
set(gca,'FontSize',fontsize,'ycolor',color);
 
h=get(0,'CurrentFigure');
axis xy;
set(gcf, 'color', bgcolor);
set(gcf, 'InvertHardCopy', 'off');

xlabel('Time[s]','FontSize',fontsize,'Color',color)
ylabel('Frequency[kHz]','FontSize',fontsize,'Color',color)
