% cr_: training correct
% cr : testing correct
feature_file = 'rel_music_raw_features+simdata_ISMIR12';
vars = whos('-file', feature_file);
A = load(feature_file,vars(1).name,vars(2).name,vars(3).name,vars(4).name);
raw_features = A.(vars(1).name);
indices      = A.(vars(2).name);
tst_inx      = A.(vars(3).name);
trn_inx      = A.(vars(4).name);
% 
% figure(1); imagesc(raw_features);colorbar;
mod = load('res_48');
features = logistic(raw_features*mod.W_max{1} + repmat(mod.hB_max{1},size(raw_features,1),1));
% figure(2); imagesc(features);colorbar;

num_case = size(trn_inx,1); 
[trnd_12 trnd_13] = subspace_distances(trn_inx,features,indices,1,1);
[tstd_12 tstd_13] = subspace_distances(tst_inx,features,indices,1,1);
cr_ = 0;   % correct rate for training
cr  = 0;   % correct rate for testing
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% CODE HERE                               %%
%[Ws cr_] = gradient_ascent(trnd_12,trnd_13,0.1,0.1,0.00002); %eNum = 10
[Ws cr_] = gradient_ascent(trnd_12,trnd_13,0.05,0.01,0.00002);

for i = 1:num_case       
 cr = cr + sum((tstd_13{i}-tstd_12{i})*Ws{i}' > 0, 1)/size(tstd_12{i},1);
end
cr = cr/num_case;
%% Check the result
fprintf('Gradient RBM Test / Train Result=%f / %f\n',cr*100,cr_*100);
%fprintf('Training=%f Testing=%f\n',cr_,cr);